package top.crystalx.sms.strategy.aliyun;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendBatchSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendBatchSmsResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.google.gson.Gson;
import top.crystalx.sms.props.AliYunProperty;
import top.crystalx.sms.core.SmsStrategy;
import top.crystalx.sms.models.R.SendResult;
import top.crystalx.sms.models.R.SmsResponse;
import top.crystalx.sms.models.aliyun.AliYunBatchModel;

import java.util.*;


/**
 * @author SIYE
 */
public class AliYunBatchSms implements SmsStrategy<AliYunProperty, AliYunBatchModel> {

    /**
     * 发送信息
     */
    @Override
    public SmsResponse sendSms(AliYunBatchModel model) {
        return sendSms(new AliYunProperty(), model);
    }

    /**
     * 发送信息
     * 自定义 阿里云配置
     */
    @Override
    public SmsResponse sendSms(AliYunProperty config, AliYunBatchModel model) {
        Client client = this.createClient(config);
        SendBatchSmsRequest request = this.createRequest(model);
        SendBatchSmsResponse response = this.getResponse(client, request);
        SmsResponse.Builder responseBuilder = SmsResponse.builder()
                .signName(model.getSignName())
                .params(model.getParams());
        if (!response.getStatusCode().equals(200)) {
            return responseBuilder.sendResults(
                    SendResult.builder().statusCode(response.getStatusCode()).message("Network Error").build()
            ).build();
        }
        int code = response.getBody().getCode().equals("OK") ? 200 : 400;
        for (String phoneNumber : model.getPhoneNumbers()) {
            responseBuilder.sendResults(
                    SendResult.builder().message(response.getBody().getMessage()).statusCode(code).phoneNumber(phoneNumber).build()
            );
        }
        return responseBuilder.build();
    }

    /**
     * 使用AK&SK初始化账号Client
     */
    private Client createClient(AliYunProperty aliYunConfig) {
        Config config = new Config()
                .setAccessKeyId(aliYunConfig.getAccessKeyId())
                .setAccessKeySecret(aliYunConfig.getAccessKeySecret())
                .setEndpoint(aliYunConfig.getEndpoint().endpoint())
                .setRegionId(aliYunConfig.getEndpoint().regionId());
        try {
            return new Client(config);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 创建request请求
     */
    private SendBatchSmsRequest createRequest(AliYunBatchModel model) {
        Gson gson = new Gson();
        List<String> signNameList = Collections.nCopies(model.getPhoneNumbers().size(), model.getSignName());
        List<Map<String, String>> paramsList = Collections.nCopies(model.getPhoneNumbers().size(), model.getParams());
        return new SendBatchSmsRequest()
                .setSignNameJson(gson.toJson(signNameList))
                .setTemplateCode(model.getTemplateCode())
                .setPhoneNumberJson(gson.toJson(model.getPhoneNumbers()))
                .setTemplateParamJson(gson.toJson(paramsList));
    }

    /**
     * 获取请求响应
     */

    private SendBatchSmsResponse getResponse(Client client, SendBatchSmsRequest request) {
        try {
            return client.sendBatchSmsWithOptions(request, new RuntimeOptions());
        } catch (TeaException error) {
            // 错误 message
            System.out.println(error.getMessage());
            // 诊断地址
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString(error.message);
            throw new RuntimeException(error);
        } catch (Exception e) {
            TeaException teaError = new TeaException(e.getMessage(), e);
            // 错误 message
            System.out.println(teaError.getMessage());
            // 诊断地址
            System.out.println(teaError.getData().get("Recommend"));
            Common.assertAsString(teaError.message);
            throw new RuntimeException(e);
        }
    }
}
