package top.crystalx.sms.strategy.aliyun;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.dysmsapi20170525.AsyncClient;
import com.aliyun.sdk.service.dysmsapi20170525.models.SendBatchSmsRequest;
import com.aliyun.sdk.service.dysmsapi20170525.models.SendBatchSmsResponse;
import com.google.gson.Gson;
import darabonba.core.client.ClientOverrideConfiguration;
import top.crystalx.sms.props.AliYunProperty;
import top.crystalx.sms.core.SmsStrategy;
import top.crystalx.sms.models.R.SendResult;
import top.crystalx.sms.models.R.SmsResponse;
import top.crystalx.sms.models.aliyun.AliYunBatchModel;

import java.util.*;
import java.util.concurrent.ExecutionException;

/**
 * @author SIYE
 */
public class AliYunBatchSmsAsync implements SmsStrategy<AliYunProperty, AliYunBatchModel> {


    /**
     * 发送信息
     */
    @Override
    public SmsResponse sendSms(AliYunBatchModel model) {
        return sendSms(new AliYunProperty(), model);
    }

    /**
     * 发送信息
     * 自定义 阿里云配置
     */
    @Override
    public SmsResponse sendSms(AliYunProperty config, AliYunBatchModel model) {
        AsyncClient client = this.createClient(config);
        SendBatchSmsRequest request = this.createRequest(model);
        SendBatchSmsResponse response = this.getResponse(client, request);
        client.close();
        SmsResponse.Builder responseBuilder = SmsResponse.builder()
                .signName(model.getSignName())
                .params(model.getParams());
        int code = response.getBody().getCode().equals("OK") ? 200 : 400;
        for (String phoneNumber : model.getPhoneNumbers()) {
            responseBuilder.sendResults(
                    SendResult.builder().message(response.getBody().getMessage()).statusCode(code).phoneNumber(phoneNumber).build()
            );
        }
        return responseBuilder.build();
    }

    /**
     * 创建客户端Client
     */
    private AsyncClient createClient(AliYunProperty config) {
        Credential.Builder builder = Credential.builder()
                .accessKeyId(config.getAccessKeyId())
                .accessKeySecret(config.getAccessKeySecret());
        if (!"".equals(config.getSecurityToken())) {
            builder.securityToken(config.getSecurityToken());
        }
        StaticCredentialProvider provider = StaticCredentialProvider.create(builder.build());
        return AsyncClient.builder()
                .region(config.getEndpoint().regionId())
                .credentialsProvider(provider)
                .overrideConfiguration(
                        ClientOverrideConfiguration.create()
                                .setEndpointOverride(config.getEndpoint().endpoint())
                )
                .build();
    }

    /**
     * 创建 Sms request
     */
    private SendBatchSmsRequest createRequest(AliYunBatchModel model) {
        Gson gson = new Gson();
        List<String> signNameList = Collections.nCopies(model.getPhoneNumbers().size(), model.getSignName());
        List<Map<String, String>> paramsList = Collections.nCopies(model.getPhoneNumbers().size(), model.getParams());
        return SendBatchSmsRequest.builder()
                .signNameJson(gson.toJson(signNameList))
                .templateCode(model.getTemplateCode())
                .phoneNumberJson(gson.toJson(model.getPhoneNumbers()))
                .templateParamJson(gson.toJson(paramsList))
                .build();
    }

    /**
     * 获取 response
     */
    private SendBatchSmsResponse getResponse(AsyncClient client, SendBatchSmsRequest request) {
        try {
            return client.sendBatchSms(request).get();
        } catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}
