package top.crystalx.sms.strategy.aliyun;

import com.aliyun.dysmsapi20170525.Client;
import com.aliyun.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.dysmsapi20170525.models.SendSmsResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import com.google.gson.Gson;
import top.crystalx.sms.models.R.SendResult;
import top.crystalx.sms.models.R.SmsResponse;
import top.crystalx.sms.models.aliyun.AliYunModel;
import top.crystalx.sms.props.AliYunProperty;
import top.crystalx.sms.core.SmsStrategy;


/**
 * @author SIYE
 */
public class AliYunSms implements SmsStrategy<AliYunProperty, AliYunModel> {

    /**
     * 发送信息
     */
    @Override
    public SmsResponse sendSms(AliYunModel model) {
        return sendSms(new AliYunProperty(), model);
    }

    /**
     * 发送信息
     * 自定义 阿里云配置
     */
    @Override
    public SmsResponse sendSms(AliYunProperty config, AliYunModel model) {
        Client client = this.createClient(config);
        SendSmsRequest request = this.createRequest(model);
        SendSmsResponse response = this.getResponse(client, request);
        SmsResponse.Builder responseBuilder = SmsResponse.builder()
                .signName(model.getSignName())
                .params(model.getParams());
        SendResult.Builder sendResultBuilder = SendResult.builder().phoneNumber(model.getPhoneNumber());
        if (!response.getStatusCode().equals(200)) {
            return responseBuilder.sendResults(
                    sendResultBuilder.statusCode(response.getStatusCode()).message("Network Error").build()
            ).build();
        }
        int code = response.getBody().getCode().equals("OK") ? 200 : 400;
        return responseBuilder.sendResults(
                sendResultBuilder.statusCode(code).message(response.getBody().getMessage()).build()
        ).build();
    }

    /**
     * 使用AK&SK初始化账号Client
     */
    private Client createClient(AliYunProperty aliYunConfig) {
        Config config = new Config()
                .setAccessKeyId(aliYunConfig.getAccessKeyId())
                .setAccessKeySecret(aliYunConfig.getAccessKeySecret())
                .setEndpoint(aliYunConfig.getEndpoint().endpoint())
                .setRegionId(aliYunConfig.getEndpoint().regionId());
        try {
            return new Client(config);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 创建 Sms request
     */
    private SendSmsRequest createRequest(AliYunModel model) {
        return new SendSmsRequest()
                .setSignName(model.getSignName())
                .setTemplateCode(model.getTemplateCode())
                .setPhoneNumbers(model.getPhoneNumber())
                .setTemplateParam(new Gson().toJson(model.getParams()));
    }


    /**
     * 获取 response
     */
    private SendSmsResponse getResponse(Client client, SendSmsRequest request) {
        RuntimeOptions runtime = new RuntimeOptions();
        try {
            return client.sendSmsWithOptions(request, runtime);
        } catch (TeaException error) {
            // 错误 message
            System.out.println(error.getMessage());
            // 诊断地址
            System.out.println(error.getData().get("Recommend"));
            Common.assertAsString(error.message);
            throw new RuntimeException(error);
        } catch (Exception e) {
            TeaException teaError = new TeaException(e.getMessage(), e);
            // 错误 message
            System.out.println(teaError.getMessage());
            // 诊断地址
            System.out.println(teaError.getData().get("Recommend"));
            Common.assertAsString(teaError.message);
            throw new RuntimeException(e);
        }
    }
}
