package top.crystalx.sms.strategy.aliyun;


import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.dysmsapi20170525.AsyncClient;
import com.aliyun.sdk.service.dysmsapi20170525.models.SendSmsRequest;
import com.aliyun.sdk.service.dysmsapi20170525.models.SendSmsResponse;
import com.google.gson.Gson;
import darabonba.core.client.ClientOverrideConfiguration;
import top.crystalx.sms.props.AliYunProperty;
import top.crystalx.sms.core.SmsStrategy;
import top.crystalx.sms.models.R.SendResult;
import top.crystalx.sms.models.R.SmsResponse;
import top.crystalx.sms.models.aliyun.AliYunModel;

import java.util.concurrent.ExecutionException;

/**
 * @author SIYE
 */
public class AliYunSmsAsync implements SmsStrategy<AliYunProperty, AliYunModel> {

    /**
     * 发送信息
     */
    @Override
    public SmsResponse sendSms(AliYunModel model) {
        return sendSms(new AliYunProperty(), model);
    }

    /**
     * 发送信息
     * 自定义 阿里云配置
     */
    @Override
    public SmsResponse sendSms(AliYunProperty config, AliYunModel model) {
        AsyncClient client = this.createClient(config);
        SendSmsRequest request = this.createRequest(model);
        SendSmsResponse response = this.getResponse(client, request);
        client.close();
        SmsResponse.Builder responseBuilder = SmsResponse.builder()
                .signName(model.getSignName())
                .params(model.getParams());
        SendResult.Builder sendResultBuilder = SendResult.builder().phoneNumber(model.getPhoneNumber());
        int code = response.getBody().getCode().equals("OK") ? 200 : 400;
        return responseBuilder.sendResults(
                sendResultBuilder.statusCode(code).message(response.getBody().getMessage()).build()
        ).build();
    }

    /**
     * 创建客户端Client
     */
    private AsyncClient createClient(AliYunProperty config) {
        Credential.Builder builder = Credential.builder()
                .accessKeyId(config.getAccessKeyId())
                .accessKeySecret(config.getAccessKeySecret());
        if (!"".equals(config.getSecurityToken())) {
            builder.securityToken(config.getSecurityToken());
        }
        StaticCredentialProvider provider = StaticCredentialProvider.create(builder.build());
        return AsyncClient.builder()
                .region(config.getEndpoint().regionId())
                .credentialsProvider(provider)
                .overrideConfiguration(
                        ClientOverrideConfiguration.create()
                                .setEndpointOverride(config.getEndpoint().endpoint())
                )
                .build();
    }

    /**
     * 创建 Sms request
     */
    private SendSmsRequest createRequest(AliYunModel model) {
        return SendSmsRequest.builder()
                .signName(model.getSignName())
                .templateCode(model.getTemplateCode())
                .phoneNumbers(model.getPhoneNumber())
                .templateParam(new Gson().toJson(model.getParams()))
                .build();
    }


    /**
     * 获取 response
     */
    private SendSmsResponse getResponse(AsyncClient client, SendSmsRequest request) {
        try {
            return client.sendSms(request).get();
        } catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}
