/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.jwt.api.cache.service.JwtCacheTransformService;
import top.dcenter.ums.security.jwt.api.id.service.JwtIdService;
import top.dcenter.ums.security.jwt.claims.service.GenerateClaimsSetService;
import top.dcenter.ums.security.jwt.decoder.UmsNimbusJwtDecoder;
import top.dcenter.ums.security.jwt.enums.JwtCustomClaimNames;
import top.dcenter.ums.security.jwt.enums.JwtRefreshHandlerPolicy;
import top.dcenter.ums.security.jwt.exception.JwtCreateException;
import top.dcenter.ums.security.jwt.exception.JwtExpiredException;
import top.dcenter.ums.security.jwt.exception.JwtInvalidException;
import top.dcenter.ums.security.jwt.exception.MismatchRefreshJwtPolicyException;
import top.dcenter.ums.security.jwt.exception.RefreshTokenInvalidException;
import top.dcenter.ums.security.jwt.exception.SaveRefreshTokenException;
import top.dcenter.ums.security.jwt.properties.BearerTokenProperties;
import top.dcenter.ums.security.jwt.properties.JwtBlacklistProperties;

public final class JwtContext {
    private static final Logger log = LoggerFactory.getLogger(JwtContext.class);
    public static final String KEY_ALGORITHM = "RSA";
    public static final int KEY_SIZE = 2048;
    public static final String BEARER = "bearer ";
    public static final String TEMPORARY_JWT_REFRESH_TOKEN = "TEMPORARY_JWT_REFRESH_TOKEN";
    private static volatile JWSSigner signer = null;
    private static volatile String jwsAlgorithm = null;
    private static volatile String kid = null;
    private static volatile Duration timeout = Duration.ofHours(1L);
    private static volatile Duration clockSkew = Duration.ofSeconds(0L);
    private static volatile JwtRefreshHandlerPolicy refreshHandlerPolicy = null;
    private static volatile BearerTokenProperties bearerToken = null;
    private static volatile RedisConnectionFactory redisConnectionFactory = null;
    private static volatile JwtBlacklistProperties blacklistProperties = null;
    private static volatile JwtIdService jwtIdService = null;
    private static volatile JwtCacheTransformService<?> jwtCacheTransformService = null;

    private JwtContext() {
    }

    public static JWK generateJwk(String kid, KeyUse keyUse) throws NoSuchAlgorithmException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        gen.initialize(2048);
        KeyPair keyPair = gen.generateKeyPair();
        return new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey((RSAPrivateKey)keyPair.getPrivate()).keyUse(keyUse).keyID(kid).build();
    }

    public static JWK generateJwk(KeyPair keyPair, String kid, KeyUse keyUse) {
        return new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey((RSAPrivateKey)keyPair.getPrivate()).keyUse(keyUse).keyID(kid).build();
    }

    @NonNull
    public static Authentication createJwtAndToJwtAuthenticationToken(@NonNull Authentication authentication, @Nullable GenerateClaimsSetService generateClaimsSetService) throws JwtCreateException {
        if (Objects.nonNull(generateClaimsSetService) && JwtContext.isSupportCreateJwt(authentication).booleanValue()) {
            try {
                Jwt refreshTokenJwt = null;
                if (JwtRefreshHandlerPolicy.REFRESH_TOKEN.equals(refreshHandlerPolicy)) {
                    String principalClaimName = generateClaimsSetService.getPrincipalClaimName();
                    refreshTokenJwt = JwtContext.generateRefreshToken(principalClaimName, authentication.getName());
                }
                JWTClaimsSet claimsSet = Objects.nonNull(refreshTokenJwt) ? generateClaimsSetService.generateClaimsSet(authentication, refreshTokenJwt) : generateClaimsSetService.generateClaimsSet(authentication, null);
                Jwt jwt = JwtContext.createJwt(claimsSet);
                JwtContext.setBearerTokenAndRefreshTokenToHeader(jwt, refreshTokenJwt);
                JwtAuthenticationToken authenticationToken = JwtContext.toJwtAuthenticationToken(jwt, generateClaimsSetService.getJwtAuthenticationConverter(), Boolean.FALSE);
                JwtContext.removeReAuthFlag(authentication.getName());
                return authenticationToken;
            }
            catch (Exception e) {
                String msg = String.format("\u521b\u5efa jwt token \u5931\u8d25: %s", authentication);
                log.error(msg, (Throwable)e);
                throw new JwtCreateException(ErrorCodeEnum.CREATE_JWT_ERROR, MdcUtil.getMdcTraceId());
            }
        }
        return authentication;
    }

    @NonNull
    public static Jwt resetJwtExpOfAutoRenewPolicy(@NonNull Jwt jwt, @NonNull UmsNimbusJwtDecoder jwtDecoder, @NonNull JwtRefreshHandlerPolicy policy, @NonNull String principalClaimName) throws ParseException, JOSEException, JwtInvalidException {
        if (!JwtRefreshHandlerPolicy.AUTO_RENEW.equals(policy)) {
            throw new MismatchRefreshJwtPolicyException(ErrorCodeEnum.REFRESH_JWT_POLICY_MISMATCH, MdcUtil.getMdcTraceId());
        }
        BlacklistType blacklistType = JwtContext.jtiInTheBlacklist(jwt.getId());
        String newJwtString = JwtContext.inBlacklistAndHasNewJwt(blacklistType);
        if (newJwtString != null) {
            Jwt newJwt = jwtDecoder.decodeNotValidate(JwtContext.removeBearerForJwtTokenString(newJwtString));
            JwtContext.setBearerTokenAndRefreshTokenToHeader(newJwt, null);
            return newJwt;
        }
        if (Objects.isNull(signer)) {
            throw new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
        }
        Map claims = jwt.getClaims();
        claims.put("jti", jwtIdService.generateJtiId());
        Instant now = Instant.now();
        claims.put("exp", now.plusSeconds(timeout.getSeconds()));
        Instant iat = (Instant)claims.get("iat");
        Instant nbf = (Instant)claims.get("nbf");
        long nowEpochSecond = now.getEpochSecond();
        if (Objects.nonNull(iat)) {
            claims.put("iat", nowEpochSecond);
            if (Objects.nonNull(nbf)) {
                claims.put("nbf", nowEpochSecond + (nbf.getEpochSecond() - iat.getEpochSecond()));
            }
        }
        claims.entrySet().stream().filter(entry -> entry.getValue() instanceof Instant).forEach(entry -> entry.setValue(((Instant)entry.getValue()).getEpochSecond()));
        Jwt newJwt = JwtContext.createJwt(JwtContext.getJwsHeader(), JwtContext.toJwtClaimsSet(claims));
        JwtContext.addBlacklist(jwt, newJwt, principalClaimName);
        JwtContext.setBearerTokenAndRefreshTokenToHeader(newJwt, null);
        return newJwt;
    }

    @NonNull
    public static Jwt generateJwtByRefreshToken(@NonNull String refreshToken, @NonNull Boolean alwaysRefresh, @NonNull HttpServletRequest request, @NonNull UmsNimbusJwtDecoder jwtDecoder, @NonNull UmsUserDetailsService umsUserDetailsService, @NonNull GenerateClaimsSetService generateClaimsSetService) throws JwtCreateException, RefreshTokenInvalidException, JwtInvalidException {
        Instant expiresAt;
        Jwt refreshTokenJwt = jwtDecoder.decodeRefreshTokenOfJwt(JwtContext.removeBearerForJwtTokenString(refreshToken));
        String userIdByRefreshToken = JwtContext.getUserIdByRefreshToken(refreshTokenJwt, jwtDecoder.getPrincipalClaimName());
        if (!StringUtils.hasText((String)userIdByRefreshToken)) {
            throw new RefreshTokenInvalidException(ErrorCodeEnum.JWT_REFRESH_TOKEN_INVALID, MdcUtil.getMdcTraceId());
        }
        UserDetails userDetails = umsUserDetailsService.loadUserByUserId(userIdByRefreshToken);
        if (Objects.isNull(userDetails)) {
            throw new RefreshTokenInvalidException(ErrorCodeEnum.JWT_REFRESH_TOKEN_INVALID, MdcUtil.getMdcTraceId());
        }
        Jwt newJwt = null;
        Jwt oldJwt = JwtContext.getJwtByRequest(request, jwtDecoder);
        if (!alwaysRefresh.booleanValue() && Objects.nonNull(oldJwt) && Objects.nonNull(expiresAt = oldJwt.getExpiresAt())) {
            boolean toRefresh;
            long remainingRefreshInterval = jwtDecoder.getRemainingRefreshInterval().getSeconds();
            boolean bl = toRefresh = expiresAt.getEpochSecond() - Instant.now().getEpochSecond() < remainingRefreshInterval;
            if (!toRefresh) {
                newJwt = oldJwt;
            }
        }
        if (Objects.isNull(newJwt)) {
            JWTClaimsSet jwtClaimsSet = generateClaimsSetService.generateClaimsSet(userDetails, refreshTokenJwt);
            try {
                newJwt = JwtContext.createJwt(jwtClaimsSet);
            }
            catch (JOSEException | ParseException e) {
                log.error(e.getMessage(), e);
                throw new JwtCreateException(ErrorCodeEnum.CREATE_JWT_ERROR, MdcUtil.getMdcTraceId());
            }
        }
        if (!blacklistProperties.getEnable().booleanValue()) {
            JwtContext.toJwtAuthenticationToken(newJwt, generateClaimsSetService.getJwtAuthenticationConverter(), Boolean.TRUE);
        }
        if (Objects.nonNull(oldJwt) && !Objects.equals(newJwt, oldJwt)) {
            JwtContext.setOldJwtToBlacklist(refreshToken, userIdByRefreshToken, oldJwt, newJwt, jwtDecoder.getPrincipalClaimName());
        }
        JwtContext.setBearerTokenAndRefreshTokenToHeader(newJwt, refreshTokenJwt);
        return newJwt;
    }

    @Nullable
    public static String getJwtRefreshTokenFromSession() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        String refreshToken = (String)requestAttributes.getAttribute(TEMPORARY_JWT_REFRESH_TOKEN, 1);
        if (Objects.nonNull(refreshToken)) {
            requestAttributes.removeAttribute(TEMPORARY_JWT_REFRESH_TOKEN, 1);
        }
        return refreshToken;
    }

    @Nullable
    public static Object getTokenInfoFromRedis(@NonNull String jti) throws SerializationException {
        if (blacklistProperties.getEnable().booleanValue()) {
            return null;
        }
        byte[] authBytes = JwtContext.getConnection().get(JwtContext.getTokenKey(jti));
        if (Objects.isNull(authBytes)) {
            return null;
        }
        try {
            return jwtCacheTransformService.deserialize(authBytes);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @NonNull
    public static Boolean isRefreshJwtByRefreshToken() {
        if (Objects.isNull(refreshHandlerPolicy)) {
            return Boolean.FALSE;
        }
        return JwtRefreshHandlerPolicy.REFRESH_TOKEN.equals(refreshHandlerPolicy);
    }

    @Nullable
    public static String inBlacklistAndHasNewJwt(@NonNull BlacklistType blacklistType) throws JwtInvalidException {
        if (blacklistType.isInBlacklist().booleanValue()) {
            String blackListValue = blacklistType.getOneTimeNewJwtValue();
            return Optional.ofNullable(blackListValue).orElseThrow(() -> new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId()));
        }
        return null;
    }

    @NonNull
    public static BlacklistType jtiInTheBlacklist(@NonNull String jti) {
        if (!blacklistProperties.getEnable().booleanValue()) {
            Boolean exists = JwtContext.getConnection().exists(JwtContext.getTokenKey(jti));
            if (Objects.nonNull(exists) && exists.booleanValue()) {
                return BlacklistType.NOT_IN_BLACKLIST;
            }
            return BlacklistType.IN_BLACKLIST;
        }
        byte[] result = JwtContext.getConnection().get(JwtContext.getBlacklistKey(jti));
        String blacklistValue = Objects.isNull(result) ? null : new String(result, StandardCharsets.UTF_8);
        return BlacklistType.getBlacklistType(blacklistValue);
    }

    @NonNull
    public static Boolean refreshJwtInTheBlacklist(@NonNull Jwt refreshJwt, @NonNull String principalClaimName) {
        if (!blacklistProperties.getEnable().booleanValue()) {
            Boolean exists = JwtContext.getConnection().exists(JwtContext.getRefreshTokenKey(refreshJwt.getClaimAsString(principalClaimName)));
            return Objects.isNull(exists) || exists == false;
        }
        Boolean exists = JwtContext.getConnection().exists(JwtContext.getBlacklistKey(refreshJwt.getId()));
        return Objects.nonNull(exists) && exists != false;
    }

    public static void addBlacklistForRefreshToken(Jwt refreshTokenJwt, String principalClaimName) {
        String userId = refreshTokenJwt.getClaimAsString(principalClaimName);
        RedisConnection connection = JwtContext.getConnection();
        if (!blacklistProperties.getEnable().booleanValue()) {
            connection.del((byte[][])new byte[][]{JwtContext.getRefreshTokenKey(userId)});
            return;
        }
        Instant expiresAt = refreshTokenJwt.getExpiresAt();
        if (Objects.isNull(expiresAt)) {
            return;
        }
        Instant now = Instant.now();
        if (expiresAt.isAfter(now.minus(clockSkew))) {
            connection.set(JwtContext.getBlacklistKey(refreshTokenJwt.getId()), BlacklistType.IN_BLACKLIST.name().getBytes(StandardCharsets.UTF_8), Expiration.seconds((long)(expiresAt.getEpochSecond() - now.getEpochSecond() + clockSkew.getSeconds())), RedisStringCommands.SetOption.SET_IF_ABSENT);
        }
    }

    public static void addBlacklistForReAuth(@NonNull Jwt oldJwt, @NonNull String principalClaimName) {
        JwtContext.addBlacklist(oldJwt, BlacklistType.IN_BLACKLIST.name().getBytes(StandardCharsets.UTF_8), principalClaimName, Boolean.TRUE);
    }

    private static void addBlacklist(@NonNull Jwt oldJwt, @NonNull Jwt newJwt, @NonNull String principalClaimName) {
        JwtContext.addBlacklist(oldJwt, newJwt.getTokenValue().getBytes(StandardCharsets.UTF_8), principalClaimName, Boolean.FALSE);
    }

    @Nullable
    public static String getRefreshTokenOrBearerToken(@NonNull HttpServletRequest request, @NonNull String parameterName, @NonNull String headerName) {
        if (Objects.isNull(bearerToken)) {
            return null;
        }
        Boolean allowFormEncodedBodyParameter = bearerToken.getAllowFormEncodedBodyParameter();
        Boolean allowUriQueryParameter = bearerToken.getAllowUriQueryParameter();
        String token = allowFormEncodedBodyParameter != false || allowUriQueryParameter != false ? request.getParameter(parameterName) : request.getHeader(headerName);
        return token;
    }

    @NonNull
    public static Duration getClockSkew() {
        return clockSkew;
    }

    @Nullable
    public static String getJwtStringIfAllowBodyParameter(@NonNull Authentication authentication) {
        if (Objects.isNull(bearerToken)) {
            return null;
        }
        Boolean allowFormEncodedBodyParameter = bearerToken.getAllowFormEncodedBodyParameter();
        if (authentication instanceof AbstractOAuth2TokenAuthenticationToken && allowFormEncodedBodyParameter.booleanValue()) {
            AbstractOAuth2TokenAuthenticationToken jwtAuthenticationToken = (AbstractOAuth2TokenAuthenticationToken)authentication;
            return ((Jwt)jwtAuthenticationToken.getToken()).getTokenValue();
        }
        return null;
    }

    @Nullable
    public static Long getJwtExpiresInByAuthentication(Authentication authentication) {
        if (Objects.isNull(timeout) && Objects.isNull(bearerToken)) {
            return null;
        }
        if (authentication instanceof AbstractOAuth2TokenAuthenticationToken) {
            return timeout.minusSeconds(1L).getSeconds();
        }
        return null;
    }

    @NonNull
    public static Boolean addReAuthFlag(@NonNull String userId) {
        Boolean result = JwtContext.getConnection().set(JwtContext.getReAuthKey(userId), "1".getBytes(StandardCharsets.UTF_8), Expiration.seconds((long)blacklistProperties.getRefreshTokenTtl().getSeconds()), RedisStringCommands.SetOption.SET_IF_ABSENT);
        if (Objects.isNull(result)) {
            return Boolean.FALSE;
        }
        return result;
    }

    @NonNull
    public static Boolean isReAuth(@NonNull String userId) {
        Boolean exists = JwtContext.getConnection().exists(JwtContext.getReAuthKey(userId));
        return Objects.nonNull(exists) && exists != false;
    }

    private static void removeReAuthFlag(@NonNull String userId) {
        JwtContext.getConnection().del((byte[][])new byte[][]{JwtContext.getReAuthKey(userId)});
    }

    private static void saveTokenSessionToRedis(@NonNull Authentication authentication, @NonNull Jwt jwt, @NonNull Boolean isSetContext) {
        if (!blacklistProperties.getEnable().booleanValue()) {
            byte[] tokenValue = jwtCacheTransformService.serialize(authentication);
            Instant expiresAt = jwt.getExpiresAt();
            if (Objects.isNull(expiresAt)) {
                return;
            }
            if (isSetContext.booleanValue()) {
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
            Duration ttl = Duration.ofSeconds(expiresAt.getEpochSecond() - Instant.now().getEpochSecond());
            JwtContext.getConnection().set(JwtContext.getTokenKey(jwt.getId()), tokenValue, Expiration.from((Duration)ttl), RedisStringCommands.SetOption.UPSERT);
        }
    }

    private static void setOldJwtToBlacklist(@NonNull String refreshToken, @NonNull String userIdByRefreshToken, @NonNull Jwt oldJwt, @NonNull Jwt newJwt, @NonNull String principalClaimName) {
        if (!blacklistProperties.getEnable().booleanValue()) {
            JwtContext.getConnection().del((byte[][])new byte[][]{JwtContext.getTokenKey(oldJwt.getId())});
            return;
        }
        Object oldUserId = oldJwt.getClaim(principalClaimName);
        if (!Objects.equals(oldUserId, userIdByRefreshToken)) {
            log.error("oldUserId: {} \u4e0e userIdByRefreshToken: {} \u4e0d\u5339\u914d, refreshToken: {}", new Object[]{oldUserId, userIdByRefreshToken, refreshToken});
            JwtContext.getConnection().del((byte[][])new byte[][]{JwtContext.getRefreshTokenKey(userIdByRefreshToken)});
            throw new RefreshTokenInvalidException(ErrorCodeEnum.JWT_REFRESH_TOKEN_INVALID, MdcUtil.getMdcTraceId());
        }
        JwtContext.addBlacklist(oldJwt, newJwt, principalClaimName);
    }

    private static void addBlacklist(@NonNull Jwt oldJwt, @NonNull byte[] value, @NonNull String principalClaimName, @NonNull Boolean isReAuth) {
        boolean isReAuthAndRefreshPolicy;
        String userId = oldJwt.getClaimAsString(principalClaimName);
        RedisConnection connection = JwtContext.getConnection();
        boolean bl = isReAuthAndRefreshPolicy = isReAuth != false && JwtRefreshHandlerPolicy.REFRESH_TOKEN.equals(refreshHandlerPolicy);
        if (!blacklistProperties.getEnable().booleanValue()) {
            if (isReAuthAndRefreshPolicy) {
                connection.del((byte[][])new byte[][]{JwtContext.getRefreshTokenKey(userId), JwtContext.getTokenKey(oldJwt.getId())});
            } else {
                connection.del((byte[][])new byte[][]{JwtContext.getTokenKey(oldJwt.getId())});
            }
            return;
        }
        Instant expiresAt = oldJwt.getExpiresAt();
        if (Objects.isNull(expiresAt)) {
            return;
        }
        Instant now = Instant.now();
        if (expiresAt.isAfter(now.minus(clockSkew))) {
            connection.set(JwtContext.getBlacklistKey(oldJwt.getId()), value, Expiration.seconds((long)(expiresAt.getEpochSecond() - now.getEpochSecond() + clockSkew.getSeconds())), RedisStringCommands.SetOption.SET_IF_ABSENT);
        }
        if (isReAuthAndRefreshPolicy) {
            String rJti = oldJwt.getClaimAsString(JwtCustomClaimNames.REFRESH_TOKEN_JTI.getClaimName());
            connection.set(JwtContext.getBlacklistKey(rJti), value, Expiration.seconds((long)blacklistProperties.getRefreshTokenTtl().getSeconds()), RedisStringCommands.SetOption.SET_IF_ABSENT);
        }
    }

    @NonNull
    private static byte[] getBlacklistKey(String jti) {
        return blacklistProperties.getBlacklistPrefix().concat(jti).getBytes(StandardCharsets.UTF_8);
    }

    @NonNull
    private static byte[] getReAuthKey(String userId) {
        return blacklistProperties.getReAuthPrefix().concat(userId).getBytes(StandardCharsets.UTF_8);
    }

    @NonNull
    private static byte[] getRefreshTokenKey(String refreshToken) {
        return blacklistProperties.getRefreshTokenPrefix().concat(refreshToken).getBytes(StandardCharsets.UTF_8);
    }

    @NonNull
    private static byte[] getTokenKey(String userId) {
        return blacklistProperties.getTokenInfoPrefix().concat(userId).getBytes(StandardCharsets.UTF_8);
    }

    private static RedisConnection getConnection() {
        return redisConnectionFactory.getConnection();
    }

    @Nullable
    private static Jwt getJwtByRequest(@NonNull HttpServletRequest request, @NonNull UmsNimbusJwtDecoder jwtDecoder) {
        Jwt oldJwt;
        String jwtString = JwtContext.getRefreshTokenOrBearerToken(request, bearerToken.getBearerTokenParameterName(), bearerToken.getBearerTokenHeaderName());
        if (!StringUtils.hasText((String)jwtString)) {
            return null;
        }
        try {
            oldJwt = jwtDecoder.decodeNotRefreshToken(JwtContext.removeBearerForJwtTokenString(jwtString));
        }
        catch (JwtException | JwtExpiredException | JwtInvalidException e) {
            oldJwt = null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            oldJwt = null;
        }
        return oldJwt;
    }

    @Nullable
    private static String getUserIdByRefreshToken(@NonNull Jwt refreshTokenJwt, @NonNull String principalClaimName) throws JwtInvalidException {
        String userId = refreshTokenJwt.getClaimAsString(principalClaimName);
        RedisConnection connection = JwtContext.getConnection();
        if (!blacklistProperties.getEnable().booleanValue()) {
            Boolean exists = connection.exists(JwtContext.getRefreshTokenKey(userId));
            if (Objects.isNull(exists) || !exists.booleanValue()) {
                return null;
            }
            return userId;
        }
        Boolean exists = connection.exists(JwtContext.getBlacklistKey(refreshTokenJwt.getId()));
        if (Objects.nonNull(exists) && exists.booleanValue()) {
            return null;
        }
        return userId;
    }

    @NonNull
    private static Jwt generateRefreshToken(@NonNull String userIdClaimName, @NonNull String userId) {
        String refreshToken;
        Jwt jwt;
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        builder.claim("jti", (Object)jwtIdService.generateJtiId());
        builder.claim(userIdClaimName, (Object)userId);
        builder.claim("exp", (Object)Instant.now().plusSeconds(blacklistProperties.getRefreshTokenTtl().getSeconds()).toEpochMilli());
        try {
            jwt = JwtContext.createJwt(builder.build());
            refreshToken = jwt.getTokenValue();
        }
        catch (JOSEException | ParseException e) {
            throw new JwtCreateException(ErrorCodeEnum.CREATE_JWT_ERROR, MdcUtil.getMdcTraceId());
        }
        if (!JwtContext.saveRefreshToken(userId, refreshToken).booleanValue()) {
            throw new SaveRefreshTokenException(ErrorCodeEnum.SAVE_REFRESH_TOKEN_ERROR, MdcUtil.getMdcTraceId());
        }
        return jwt;
    }

    @NonNull
    private static Boolean saveRefreshToken(@NonNull String userId, @NonNull String refreshToken) {
        if (!blacklistProperties.getEnable().booleanValue() && JwtRefreshHandlerPolicy.REFRESH_TOKEN.equals(refreshHandlerPolicy)) {
            Boolean isSuccess = JwtContext.getConnection().set(JwtContext.getRefreshTokenKey(userId), refreshToken.getBytes(StandardCharsets.UTF_8), Expiration.from((Duration)blacklistProperties.getRefreshTokenTtl().minusSeconds(1L)), RedisStringCommands.SetOption.UPSERT);
            if (Objects.isNull(isSuccess)) {
                return false;
            }
            return isSuccess;
        }
        return true;
    }

    @NonNull
    private static String removeBearerForJwtTokenString(@NonNull String jwtTokenString) {
        if (jwtTokenString.startsWith(BEARER)) {
            return jwtTokenString.replaceFirst(BEARER, "");
        }
        return jwtTokenString;
    }

    private static void setBearerTokenAndRefreshTokenToHeader(@NonNull Jwt jwt, @Nullable Jwt refreshTokenJwt) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = requestAttributes.getResponse();
        String bearerToken = BEARER + jwt.getTokenValue();
        if (Objects.isNull(response) || Objects.isNull(JwtContext.bearerToken)) {
            throw new IllegalStateException("HttpServletResponse is closed or does not support setting bearer token to header");
        }
        if (Objects.nonNull(refreshTokenJwt) && JwtRefreshHandlerPolicy.REFRESH_TOKEN.equals(refreshHandlerPolicy)) {
            String refreshTokenHeaderName = JwtContext.bearerToken.getRefreshTokenHeaderName();
            String refreshTokenJwtValue = refreshTokenJwt.getTokenValue();
            if (!JwtContext.bearerToken.getAllowFormEncodedBodyParameter().booleanValue()) {
                response.setHeader(refreshTokenHeaderName, refreshTokenJwtValue);
            } else {
                requestAttributes.setAttribute(TEMPORARY_JWT_REFRESH_TOKEN, (Object)refreshTokenJwtValue, 1);
            }
        }
        boolean isAutoRenewPolicy = JwtRefreshHandlerPolicy.AUTO_RENEW.equals(refreshHandlerPolicy);
        if (!JwtContext.bearerToken.getAllowFormEncodedBodyParameter().booleanValue() || isAutoRenewPolicy) {
            String bearerTokenHeaderName = JwtContext.bearerToken.getBearerTokenHeaderName();
            response.setHeader(bearerTokenHeaderName, bearerToken);
        }
    }

    @NonNull
    private static Boolean isSupportCreateJwt(@NonNull Authentication authentication) {
        return Objects.nonNull(signer) && !(authentication instanceof AbstractOAuth2TokenAuthenticationToken);
    }

    @NonNull
    private static JwtAuthenticationToken toJwtAuthenticationToken(@NonNull Jwt jwt, @NonNull JwtAuthenticationConverter converter, @NonNull Boolean isSetToContext) {
        JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)converter.convert(jwt);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Objects.nonNull(authentication)) {
            jwtAuthenticationToken.setDetails(authentication.getDetails());
        }
        if (!blacklistProperties.getEnable().booleanValue()) {
            JwtContext.saveTokenSessionToRedis((Authentication)jwtAuthenticationToken, jwt, isSetToContext);
        } else if (isSetToContext.booleanValue()) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)jwtAuthenticationToken);
        }
        return jwtAuthenticationToken;
    }

    @NonNull
    private static JWTClaimsSet toJwtClaimsSet(@NonNull Map<String, Object> claims) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        claims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        return builder.build();
    }

    @NonNull
    private static Jwt createJwt(@NonNull JWTClaimsSet claimsSet) throws JOSEException, ParseException {
        Objects.requireNonNull(signer, "JWSSigner \u4e0d\u5b58\u5728, \u4e0d\u652f\u6301\u521b\u5efa JWT \u529f\u80fd");
        JWSHeader jwsHeader = JwtContext.getJwsHeader();
        return JwtContext.createJwt(jwsHeader, claimsSet);
    }

    @NonNull
    private static Jwt createJwt(@NonNull JWSHeader jwsHeader, @NonNull JWTClaimsSet claimsSet) throws JOSEException, ParseException {
        Objects.requireNonNull(signer, "signer \u4e0d\u5b58\u5728, \u4e0d\u652f\u6301 JWT \u529f\u80fd");
        SignedJWT signedjwt = new SignedJWT(jwsHeader, claimsSet);
        signedjwt.sign(signer);
        String tokenValue = signedjwt.serialize();
        Long issueTime = claimsSet.getLongClaim("iat");
        Instant issueAt = null;
        if (Objects.nonNull(issueTime)) {
            issueAt = Instant.ofEpochSecond(issueTime);
        }
        return new Jwt(tokenValue, issueAt, Instant.ofEpochSecond(claimsSet.getLongClaim("exp")), (Map)jwsHeader.toJSONObject(), claimsSet.getClaims());
    }

    @NonNull
    private static JWSHeader getJwsHeader() {
        Objects.requireNonNull(jwsAlgorithm, "\u672a\u8bbe\u7f6e jwsAlgorithm, \u4e0d\u652f\u6301 JWT \u529f\u80fd");
        JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.parse((String)jwsAlgorithm));
        builder.type(JOSEObjectType.JWT);
        if (StringUtils.hasText((String)kid)) {
            builder.keyID(kid);
        }
        return builder.build();
    }

    public static enum BlacklistType {
        NOT_IN_BLACKLIST{

            @Override
            @Nullable
            public String getOneTimeNewJwtValue() {
                return null;
            }

            @Override
            @NonNull
            public Boolean isInBlacklist() {
                return false;
            }
        }
        ,
        IN_BLACKLIST{

            @Override
            @Nullable
            public String getOneTimeNewJwtValue() {
                return null;
            }

            @Override
            @NonNull
            public Boolean isInBlacklist() {
                return true;
            }
        }
        ,
        IN_BLACKLIST_AND_HAS_NEW_JWT{

            @Override
            @Nullable
            public String getOneTimeNewJwtValue() {
                try {
                    String string = (String)JWT_VALUE.get();
                    return string;
                }
                finally {
                    JWT_VALUE.remove();
                }
            }

            @Override
            @NonNull
            public Boolean isInBlacklist() {
                return true;
            }
        };

        private static final ThreadLocal<String> JWT_VALUE;

        @NonNull
        public static BlacklistType getBlacklistType(@Nullable String blacklistValue) {
            if (!StringUtils.hasText((String)blacklistValue)) {
                return NOT_IN_BLACKLIST;
            }
            if (IN_BLACKLIST.name().equals(blacklistValue)) {
                return IN_BLACKLIST;
            }
            JWT_VALUE.set(blacklistValue);
            return IN_BLACKLIST_AND_HAS_NEW_JWT;
        }

        @Nullable
        public abstract String getOneTimeNewJwtValue();

        @NonNull
        public abstract Boolean isInBlacklist();

        static {
            JWT_VALUE = new ThreadLocal();
        }
    }
}

