/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.advice;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;

@Order(value=97)
@ControllerAdvice
public class JwtControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(JwtControllerAdvice.class);

    @ExceptionHandler(value={OAuth2AuthenticationException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult oAuth2AuthenticationException(OAuth2AuthenticationException ex) {
        String errorMsg = ex.getMessage();
        return ResponseResult.fail((String)errorMsg, (ErrorCodeEnum)ErrorCodeEnum.UNAUTHORIZED, (Object)MdcUtil.getMdcTraceId());
    }
}

