/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.api.claims.service;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import top.dcenter.ums.security.jwt.enums.JwtCustomClaimNames;

public interface CustomClaimsSetService {
    @NonNull
    public JWTClaimsSet toClaimsSet(@NonNull Authentication var1);

    @NonNull
    public JWTClaimsSet toClaimsSet(@NonNull UserDetails var1);

    @NonNull
    default public JWTClaimsSet.Builder getJwtClaimsSetBuilderWithAuthorities(@NonNull Collection<? extends GrantedAuthority> authorities) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        String authoritiesString = authorities.stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(" "));
        builder.claim(JwtCustomClaimNames.AUTHORITIES.getClaimName(), (Object)authoritiesString);
        return builder;
    }
}

