/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.cache.service;

import java.util.Objects;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import top.dcenter.ums.security.jwt.api.cache.service.JwtCacheTransformService;

public class UmsJwtCacheTransformServiceImpl
implements JwtCacheTransformService<JwtAuthenticationToken> {
    @Qualifier(value="jwtTokenRedisSerializer")
    private final RedisSerializer<JwtAuthenticationToken> redisSerializer;

    @Override
    @NonNull
    public byte[] serialize(@NonNull Authentication authentication) throws SerializationException {
        byte[] result;
        if (authentication instanceof JwtAuthenticationToken && Objects.nonNull(result = this.redisSerializer.serialize((Object)((JwtAuthenticationToken)authentication)))) {
            return result;
        }
        throw new SerializationException("\u5e8f\u5217\u5316\u9519\u8bef");
    }

    @Override
    @NonNull
    public JwtAuthenticationToken deserialize(@NonNull byte[] bytes) throws SerializationException {
        JwtAuthenticationToken deserialize = (JwtAuthenticationToken)this.redisSerializer.deserialize(bytes);
        if (Objects.nonNull(deserialize)) {
            return deserialize;
        }
        throw new SerializationException("\u53cd\u5e8f\u5217\u5316\u9519\u8bef");
    }

    @Override
    @NonNull
    public Class<JwtAuthenticationToken> getClazz() {
        return JwtAuthenticationToken.class;
    }

    public UmsJwtCacheTransformServiceImpl(RedisSerializer<JwtAuthenticationToken> redisSerializer) {
        this.redisSerializer = redisSerializer;
    }
}

