/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.claims.service.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import top.dcenter.ums.security.core.api.tenant.handler.TenantContextHolder;
import top.dcenter.ums.security.jwt.api.claims.service.CustomClaimsSetService;
import top.dcenter.ums.security.jwt.api.id.service.JwtIdService;
import top.dcenter.ums.security.jwt.claims.service.GenerateClaimsSetService;
import top.dcenter.ums.security.jwt.enums.JwtCustomClaimNames;

public class UmsGenerateClaimsSetServiceImpl
implements GenerateClaimsSetService {
    private static final Logger log = LoggerFactory.getLogger(UmsGenerateClaimsSetServiceImpl.class);
    private final long timeout;
    private final String iss;
    private final String principalClaimName;
    private final JwtAuthenticationConverter jwtAuthenticationConverter;
    @Autowired(required=false)
    private TenantContextHolder tenantContextHolder;
    @Autowired(required=false)
    private CustomClaimsSetService customClaimsSetService;
    @Autowired
    private JwtIdService jwtIdService;

    public UmsGenerateClaimsSetServiceImpl(@NonNull long timeout, @Nullable String iss, @NonNull String principalClaimName, @NonNull JwtAuthenticationConverter jwtAuthenticationConverter) {
        this.timeout = timeout;
        this.iss = iss;
        this.principalClaimName = principalClaimName;
        this.jwtAuthenticationConverter = jwtAuthenticationConverter;
    }

    @Override
    @NonNull
    public JWTClaimsSet generateClaimsSet(@NonNull UserDetails userDetails, @Nullable Jwt refreshTokenJwt) {
        String tenantId = null;
        if (Objects.nonNull(this.tenantContextHolder)) {
            tenantId = this.tenantContextHolder.getTenantId(userDetails);
        }
        JWTClaimsSet.Builder builder = this.getJwtClaimsSetBuilder(tenantId, userDetails.getUsername(), refreshTokenJwt);
        if (Objects.nonNull(refreshTokenJwt)) {
            builder.claim(JwtCustomClaimNames.REFRESH_TOKEN_JTI.getClaimName(), (Object)refreshTokenJwt.getId());
        }
        if (Objects.nonNull(this.customClaimsSetService)) {
            JWTClaimsSet jwtClaimsSet = this.customClaimsSetService.toClaimsSet(userDetails);
            jwtClaimsSet.getClaims().forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        }
        return builder.build();
    }

    @Override
    @NonNull
    public JWTClaimsSet generateClaimsSet(@NonNull Authentication authentication, @Nullable Jwt refreshTokenJwt) {
        String tenantId = null;
        if (Objects.nonNull(this.tenantContextHolder)) {
            tenantId = this.tenantContextHolder.getTenantId(authentication);
        }
        JWTClaimsSet.Builder builder = this.getJwtClaimsSetBuilder(tenantId, authentication.getName(), refreshTokenJwt);
        if (Objects.nonNull(this.customClaimsSetService)) {
            JWTClaimsSet jwtClaimsSet = this.customClaimsSetService.toClaimsSet(authentication);
            jwtClaimsSet.getClaims().forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        }
        return builder.build();
    }

    @Override
    @NonNull
    public String getPrincipalClaimName() {
        return this.principalClaimName;
    }

    @Override
    @NonNull
    public JwtAuthenticationConverter getJwtAuthenticationConverter() {
        return this.jwtAuthenticationConverter;
    }

    private JWTClaimsSet.Builder getJwtClaimsSetBuilder(@Nullable String tenantId, @NonNull String userId, @Nullable Jwt refreshTokenJwt) {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        if (Objects.nonNull(tenantId)) {
            builder.claim(JwtCustomClaimNames.TENANT_ID.getClaimName(), (Object)tenantId);
        }
        if (Objects.nonNull(this.iss)) {
            builder.issuer(this.iss);
        }
        builder.jwtID(this.jwtIdService.generateJtiId());
        builder.claim(this.principalClaimName, (Object)userId).claim("exp", (Object)Instant.now().plusSeconds(this.timeout).getEpochSecond());
        if (Objects.nonNull(refreshTokenJwt)) {
            builder.claim(JwtCustomClaimNames.REFRESH_TOKEN_JTI.getClaimName(), (Object)refreshTokenJwt.getId());
        }
        return builder;
    }
}

