/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.config;

import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.utils.ReflectionUtil;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.jwt.JwtContext;
import top.dcenter.ums.security.jwt.advice.JwtControllerAdvice;
import top.dcenter.ums.security.jwt.api.cache.service.JwtCacheTransformService;
import top.dcenter.ums.security.jwt.api.claims.service.CustomClaimsSetService;
import top.dcenter.ums.security.jwt.api.endpoind.service.JwkEndpointPermissionService;
import top.dcenter.ums.security.jwt.api.id.service.JwtIdService;
import top.dcenter.ums.security.jwt.api.supplier.JwtClaimTypeConverterSupplier;
import top.dcenter.ums.security.jwt.api.supplier.JwtGrantedAuthoritiesConverterSupplier;
import top.dcenter.ums.security.jwt.api.validator.service.CustomClaimValidateService;
import top.dcenter.ums.security.jwt.api.validator.service.ReAuthService;
import top.dcenter.ums.security.jwt.claims.service.GenerateClaimsSetService;
import top.dcenter.ums.security.jwt.claims.service.impl.UmsCustomClaimsSetServiceImpl;
import top.dcenter.ums.security.jwt.claims.service.impl.UmsGenerateClaimsSetServiceImpl;
import top.dcenter.ums.security.jwt.config.JwtPropertiesAutoConfiguration;
import top.dcenter.ums.security.jwt.config.JwtServiceAutoConfiguration;
import top.dcenter.ums.security.jwt.config.RedisSerializerAutoConfiguration;
import top.dcenter.ums.security.jwt.controller.JwtRefreshTokenController;
import top.dcenter.ums.security.jwt.decoder.UmsNimbusJwtDecoder;
import top.dcenter.ums.security.jwt.endpoint.JwkEndpoint;
import top.dcenter.ums.security.jwt.enums.JwtRefreshHandlerPolicy;
import top.dcenter.ums.security.jwt.factory.KeyStoreKeyFactory;
import top.dcenter.ums.security.jwt.properties.BearerTokenProperties;
import top.dcenter.ums.security.jwt.properties.JwtBlacklistProperties;
import top.dcenter.ums.security.jwt.properties.JwtProperties;
import top.dcenter.ums.security.jwt.resolver.UmsBearerTokenResolver;
import top.dcenter.ums.security.jwt.supplier.UmsJwtClaimTypeConverterSupplier;
import top.dcenter.ums.security.jwt.supplier.UmsJwtGrantedAuthoritiesConverterSupplier;
import top.dcenter.ums.security.jwt.validator.JwtNotBeforeValidator;
import top.dcenter.ums.security.jwt.validator.UmsReAuthServiceImpl;

@Configuration
@Order(value=99)
@AutoConfigureAfter(value={JwtPropertiesAutoConfiguration.class, JwtServiceAutoConfiguration.class, RedisSerializerAutoConfiguration.class})
@ConditionalOnProperty(prefix="ums.jwt", name={"enable"}, havingValue="true")
public class JwtAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(JwtAutoConfiguration.class);
    public static final String SIGNER_PARAM_NAME = "signer";
    public static final String JWS_ALGORITHM_PARAM_NAME = "jwsAlgorithm";
    public static final String KID_PARAM_NAME = "kid";
    public static final String JWT_TIMEOUT = "timeout";
    public static final String CLOCK_SKEW = "clockSkew";
    public static final String BEARER_TOKEN = "bearerToken";
    public static final String REDIS_CONNECTION_FACTORY = "redisConnectionFactory";
    public static final String BLACKLIST_PROPERTIES = "blacklistProperties";
    public static final String REFRESH_HANDLER_POLICY = "refreshHandlerPolicy";
    public static final String JWT_ID_SERVICE = "jwtIdService";
    public static final String JWT_CACHE_TRANSFORM_SERVICE = "jwtCacheTransformService";
    private final RSAPublicKey publicKey;
    private final JWSSigner signer;
    private final JwsAlgorithm jwsAlgorithm;
    private final String kid;
    private final BearerTokenProperties bearerTokenProperties;
    private final RedisConnectionFactory redisConnectionFactory;
    private final JwtBlacklistProperties jwtBlacklistProperties;
    private final JwtRefreshHandlerPolicy refreshHandlerPolicy;
    private final JwtIdService jwtIdService;
    private final JwtCacheTransformService<?> jwtCacheTransformService;
    private final Duration timeout;
    private final Duration clockSkew;
    private OAuth2TokenValidator<Jwt> oAuth2TokenValidator;
    private MappedJwtClaimSetConverter mappedJwtClaimSetConverter;
    private JwtDecoder jwtDecoder;
    @Autowired(required=false)
    private Map<String, CustomClaimValidateService> customClaimValidateServiceMap;

    public JwtAutoConfiguration(JwtProperties jwtProperties, RedisConnectionFactory redisConnectionFactory, @Autowired(required=false) OAuth2ResourceServerProperties auth2ResourceServerProperties, JwtIdService jwtIdService, JwtCacheTransformService<?> jwtCacheTransformService) throws Exception {
        this.timeout = jwtProperties.getTimeout();
        this.bearerTokenProperties = jwtProperties.getBearer();
        this.jwtBlacklistProperties = jwtProperties.getBlacklist();
        this.redisConnectionFactory = redisConnectionFactory;
        this.refreshHandlerPolicy = jwtProperties.getRefreshHandlerPolicy();
        this.clockSkew = jwtProperties.getClockSkew();
        this.jwtIdService = jwtIdService;
        this.jwtCacheTransformService = jwtCacheTransformService;
        Resource resource = jwtProperties.getJksKeyPairLocation();
        if (Objects.nonNull(resource)) {
            KeyStoreKeyFactory keyStoreKeyFactory = new KeyStoreKeyFactory(resource, jwtProperties.getJksPassword().toCharArray());
            KeyPair keyPair = keyStoreKeyFactory.getKeyPair(jwtProperties.getJksAlias());
            this.publicKey = (RSAPublicKey)keyPair.getPublic();
            this.kid = jwtProperties.getKid();
            RSAKey rsaJwk = (RSAKey)JwtContext.generateJwk(keyPair, this.kid, KeyUse.SIGNATURE);
            this.signer = new RSASSASigner(rsaJwk);
            this.jwsAlgorithm = SignatureAlgorithm.from((String)jwtProperties.getJwsAlgorithms());
        } else if (Objects.nonNull(jwtProperties.getMacsSecret())) {
            String macsSecret = jwtProperties.getMacsSecret();
            if (macsSecret.length() < 32) {
                throw new RuntimeException("\u7528\u4e8e JWT \u7684 HMAC protection \u7684 secret, \u5b57\u7b26\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e 32");
            }
            this.signer = new MACSigner(macsSecret.getBytes(StandardCharsets.UTF_8));
            this.jwsAlgorithm = MacAlgorithm.from((String)jwtProperties.getJwsAlgorithms());
            this.publicKey = null;
            this.kid = jwtProperties.getKid();
        } else {
            if (Objects.nonNull(auth2ResourceServerProperties)) {
                OAuth2ResourceServerProperties.Jwt jwt = auth2ResourceServerProperties.getJwt();
                String jwsAlgorithm = jwt.getJwsAlgorithm();
                this.jwsAlgorithm = SignatureAlgorithm.from((String)jwsAlgorithm);
            } else {
                this.jwsAlgorithm = null;
            }
            this.publicKey = null;
            this.signer = null;
            this.kid = null;
        }
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.jwt.api.validator.service.ReAuthService"})
    public ReAuthService reAuthService(JwtProperties jwtProperties) {
        return new UmsReAuthServiceImpl(jwtProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.jwt.advice.JwtControllerAdvice"})
    public JwtControllerAdvice jwtControllerAdvice() {
        return new JwtControllerAdvice();
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.jwt", name={"expose-refresh-token-uri"}, havingValue="true")
    public JwtRefreshTokenController jwtRefreshTokenController(GenerateClaimsSetService generateClaimsSetService, UmsUserDetailsService umsUserDetailsService, UmsNimbusJwtDecoder jwtDecoder, JwtProperties jwtProperties) {
        return new JwtRefreshTokenController(generateClaimsSetService, umsUserDetailsService, jwtDecoder, jwtProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.jwt", name={"expose-jwk-set-uri"}, havingValue="true")
    public JwkEndpoint jwkEndpoint(JwtProperties jwtProperties, JwkEndpointPermissionService jwkEndpointPermissionService) {
        Objects.requireNonNull(this.publicKey, "jks-key-pair-location cannot bu null");
        Objects.requireNonNull(jwkEndpointPermissionService, "jwkEndpointPermissionService cannot bu null");
        return new JwkEndpoint(this.publicKey, jwtProperties.getJwsAlgorithms(), jwkEndpointPermissionService, jwtProperties.getKid());
    }

    @Bean
    public BearerTokenResolver bearerTokenResolver(JwtProperties properties) {
        BearerTokenProperties bearer = properties.getBearer();
        String bearerTokenParameterName = bearer.getBearerTokenParameterName();
        String bearerTokenHeaderName = bearer.getBearerTokenHeaderName();
        Boolean allowFormEncodedBodyParameter = bearer.getAllowFormEncodedBodyParameter();
        Boolean allowUriQueryParameter = bearer.getAllowUriQueryParameter();
        if (allowFormEncodedBodyParameter.booleanValue() && allowUriQueryParameter.booleanValue()) {
            throw new RuntimeException("\u5c5e\u6027 allowFormEncodedBodyParameter, allowUriQueryParameter \u4e0d\u80fd\u540c\u65f6\u4e3a true.");
        }
        if (!StringUtils.hasText((String)bearerTokenHeaderName) && !StringUtils.hasText((String)bearerTokenParameterName)) {
            throw new RuntimeException("\u5c5e\u6027 bearerTokenHeaderName \u6216 bearerTokenParameterName \u4e0d\u80fd\u662f null \u6216 \u7a7a\u5b57\u7b26\u4e32.");
        }
        UmsBearerTokenResolver bearerTokenResolver = new UmsBearerTokenResolver(bearerTokenParameterName, properties.getJwtByRefreshTokenUri());
        bearerTokenResolver.setBearerTokenHeaderName(bearerTokenHeaderName);
        bearerTokenResolver.setAllowFormEncodedBodyParameter(allowFormEncodedBodyParameter);
        bearerTokenResolver.setAllowUriQueryParameter(allowUriQueryParameter);
        return bearerTokenResolver;
    }

    @Bean
    @Primary
    public JwtDecoder jwtDecoder(OAuth2TokenValidator<Jwt> oAuth2TokenValidator, MappedJwtClaimSetConverter mappedJwtClaimSetConverter, @Autowired(required=false) OAuth2ResourceServerProperties auth2ResourceServerProperties, JwtProperties jwtProperties) {
        Resource jksKeyPairResource = jwtProperties.getJksKeyPairLocation();
        String macsSecret = jwtProperties.getMacsSecret();
        UmsNimbusJwtDecoder jwtDecoder = null;
        if (Objects.nonNull(jksKeyPairResource)) {
            jwtDecoder = UmsNimbusJwtDecoder.withPublicKey(this.publicKey, jwtProperties.getRefreshHandlerPolicy(), jwtProperties.getRemainingRefreshInterval(), jwtProperties.getPrincipalClaimName()).signatureAlgorithm((SignatureAlgorithm)this.jwsAlgorithm).build();
        } else if (StringUtils.hasText((String)macsSecret)) {
            jwtDecoder = UmsNimbusJwtDecoder.withSecretKey(new SecretKeySpec(macsSecret.getBytes(StandardCharsets.UTF_8), "MAC"), jwtProperties.getRefreshHandlerPolicy(), jwtProperties.getRemainingRefreshInterval(), jwtProperties.getPrincipalClaimName()).build();
        } else if (Objects.nonNull(auth2ResourceServerProperties)) {
            jwtDecoder = UmsNimbusJwtDecoder.withJwkSetUri(auth2ResourceServerProperties.getJwt().getJwkSetUri(), jwtProperties.getRefreshHandlerPolicy(), jwtProperties.getRemainingRefreshInterval(), jwtProperties.getPrincipalClaimName()).build();
        }
        if (Objects.isNull(jwtDecoder)) {
            throw new RuntimeException("\u672a\u6210\u529f\u521b\u5efa org.springframework.security.oauth2.jwt.JwtDecoder; \n\u5f53\u9700\u8981\u62e5\u6709\u521b\u5efa JWT \u529f\u80fd\u65f6\u9700\u8981\u914d\u7f6e \"ums.jwt.jksKeyPairLocation\" \u6216 \"ums.jwt.macsSecret\" \u7684\u5c5e\u6027, \n\u5f53\u4ec5\u4ec5\u9700\u8981\u89e3\u6790 JWT \u65f6\u8bf7\u914d\u7f6e \"spring.security.oauth2.resourceserver.jwt.jwk-set-uri\" \u5c5e\u6027");
        }
        this.setJwtValidatorAndClaimSetConverter(oAuth2TokenValidator, mappedJwtClaimSetConverter, jwtDecoder);
        this.jwtDecoder = jwtDecoder;
        return jwtDecoder;
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.security.oauth2.server.resource.authentication.JwtBearerTokenAuthenticationConverter"})
    public JwtAuthenticationConverter jwtAuthenticationConverter(JwtProperties jwtProperties, JwtGrantedAuthoritiesConverterSupplier jwtGrantedAuthoritiesConverterSupplier) {
        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setPrincipalClaimName(jwtProperties.getPrincipalClaimName());
        if (Objects.nonNull(jwtGrantedAuthoritiesConverterSupplier)) {
            jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter(jwtGrantedAuthoritiesConverterSupplier.getConverter());
        }
        return jwtAuthenticationConverter;
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.jwt.converter.factory.JwtClaimTypeConverterSupplier"})
    public JwtClaimTypeConverterSupplier jwtClaimTypeConverterSupplier() {
        return new UmsJwtClaimTypeConverterSupplier();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.jwt.api.supplier.JwtGrantedAuthoritiesConverterSupplier"})
    public JwtGrantedAuthoritiesConverterSupplier jwtGrantedAuthoritiesConverterSupplier() {
        return new UmsJwtGrantedAuthoritiesConverterSupplier();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.jwt.claims.service.GenerateClaimsSetService"})
    public GenerateClaimsSetService generateClaimsSetService(JwtProperties jwtProperties, JwtAuthenticationConverter jwtAuthenticationConverter) {
        return new UmsGenerateClaimsSetServiceImpl(jwtProperties.getTimeout().getSeconds(), jwtProperties.getIss(), jwtProperties.getPrincipalClaimName(), jwtAuthenticationConverter);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.jwt.api.claims.service.CustomClaimsSetService"})
    public CustomClaimsSetService customClaimsSetService() {
        return new UmsCustomClaimsSetServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.security.oauth2.core.OAuth2TokenValidator"})
    public OAuth2TokenValidator<Jwt> oAuth2TokenValidator(JwtProperties jwtProperties) {
        ArrayList<JwtNotBeforeValidator> tokenValidators = new ArrayList<JwtNotBeforeValidator>();
        tokenValidators.add(new JwtNotBeforeValidator(jwtProperties.getClockSkew()));
        if (!CollectionUtils.isEmpty(this.customClaimValidateServiceMap)) {
            this.customClaimValidateServiceMap.values().forEach(service -> tokenValidators.add((JwtNotBeforeValidator)new JwtClaimValidator(service.getClaimName(), service::validate)));
        }
        this.oAuth2TokenValidator = new DelegatingOAuth2TokenValidator(tokenValidators);
        return this.oAuth2TokenValidator;
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter"})
    public MappedJwtClaimSetConverter mappedJwtClaimSetConverter(JwtClaimTypeConverterSupplier jwtClaimTypeConverterSupplier) {
        this.mappedJwtClaimSetConverter = Objects.isNull(jwtClaimTypeConverterSupplier) ? MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap()) : MappedJwtClaimSetConverter.withDefaults(jwtClaimTypeConverterSupplier.getConverter());
        return this.mappedJwtClaimSetConverter;
    }

    public void afterPropertiesSet() throws Exception {
        Class<JwtContext> jwtUtilClass = JwtContext.class;
        Class.forName(jwtUtilClass.getName());
        if (Objects.nonNull(this.signer)) {
            ReflectionUtil.setFieldValue((String)SIGNER_PARAM_NAME, (Object)this.signer, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.jwsAlgorithm)) {
            ReflectionUtil.setFieldValue((String)JWS_ALGORITHM_PARAM_NAME, (Object)this.jwsAlgorithm.getName(), null, jwtUtilClass);
        }
        if (Objects.nonNull(this.kid)) {
            ReflectionUtil.setFieldValue((String)KID_PARAM_NAME, (Object)this.kid, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.timeout)) {
            ReflectionUtil.setFieldValue((String)JWT_TIMEOUT, (Object)this.timeout, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.clockSkew)) {
            ReflectionUtil.setFieldValue((String)CLOCK_SKEW, (Object)this.clockSkew, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.bearerTokenProperties)) {
            BearerTokenProperties bearerTokenProperties = new BearerTokenProperties();
            BeanUtils.copyProperties((Object)this.bearerTokenProperties, (Object)bearerTokenProperties);
            ReflectionUtil.setFieldValue((String)BEARER_TOKEN, (Object)bearerTokenProperties, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.jwtBlacklistProperties)) {
            JwtBlacklistProperties jwtBlacklistProperties = new JwtBlacklistProperties();
            BeanUtils.copyProperties((Object)this.jwtBlacklistProperties, (Object)jwtBlacklistProperties);
            ReflectionUtil.setFieldValue((String)BLACKLIST_PROPERTIES, (Object)jwtBlacklistProperties, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.redisConnectionFactory)) {
            ReflectionUtil.setFieldValue((String)REDIS_CONNECTION_FACTORY, (Object)this.redisConnectionFactory, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.refreshHandlerPolicy)) {
            ReflectionUtil.setFieldValue((String)REFRESH_HANDLER_POLICY, (Object)this.refreshHandlerPolicy, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.jwtIdService)) {
            ReflectionUtil.setFieldValue((String)JWT_ID_SERVICE, (Object)this.jwtIdService, null, jwtUtilClass);
        }
        if (Objects.nonNull(this.jwtCacheTransformService)) {
            ReflectionUtil.setFieldValue((String)JWT_CACHE_TRANSFORM_SERVICE, this.jwtCacheTransformService, null, jwtUtilClass);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (Objects.isNull(this.jwtDecoder)) {
            this.jwtDecoder = (JwtDecoder)applicationContext.getBean(NimbusJwtDecoder.class);
            if (Objects.isNull(this.oAuth2TokenValidator)) {
                this.oAuth2TokenValidator = (OAuth2TokenValidator)applicationContext.getBean(OAuth2TokenValidator.class);
            }
            if (Objects.isNull(this.mappedJwtClaimSetConverter)) {
                this.mappedJwtClaimSetConverter = (MappedJwtClaimSetConverter)applicationContext.getBean(MappedJwtClaimSetConverter.class);
            }
            this.setJwtValidatorAndClaimSetConverter(this.oAuth2TokenValidator, this.mappedJwtClaimSetConverter, this.jwtDecoder);
        }
    }

    private void setJwtValidatorAndClaimSetConverter(@NonNull OAuth2TokenValidator<Jwt> oAuth2TokenValidator, @NonNull MappedJwtClaimSetConverter mappedJwtClaimSetConverter, @NonNull JwtDecoder jwtDecoder) {
        Object decoder;
        if (jwtDecoder instanceof NimbusJwtDecoder) {
            decoder = (NimbusJwtDecoder)jwtDecoder;
            decoder.setJwtValidator(oAuth2TokenValidator);
            decoder.setClaimSetConverter((Converter)mappedJwtClaimSetConverter);
        }
        if (jwtDecoder instanceof UmsNimbusJwtDecoder) {
            decoder = (UmsNimbusJwtDecoder)jwtDecoder;
            ((UmsNimbusJwtDecoder)decoder).setJwtValidator(oAuth2TokenValidator);
            ((UmsNimbusJwtDecoder)decoder).setClaimSetConverter((Converter<Map<String, Object>, Map<String, Object>>)mappedJwtClaimSetConverter);
        }
    }
}

