/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.config;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtBearerTokenAuthenticationConverter;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import top.dcenter.ums.security.common.access.UmsAccessDeniedHandlerImpl;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.jwt.config.JwtAutoConfiguration;
import top.dcenter.ums.security.jwt.filter.JwtExceptionOnceFilter;

@Configuration
@AutoConfigureAfter(value={JwtAutoConfiguration.class})
@ConditionalOnProperty(prefix="ums.jwt", name={"enable"}, havingValue="true")
public class JwtAutoConfigurerAware
implements HttpSecurityAware {
    private final JwtDecoder jwtDecoder;
    private final JwtAuthenticationConverter jwtAuthenticationConverter;
    private final JwtBearerTokenAuthenticationConverter jwtBearerTokenAuthenticationConverter;

    public JwtAutoConfigurerAware(JwtDecoder jwtDecoder, @Autowired(required=false) JwtBearerTokenAuthenticationConverter jwtBearerTokenAuthenticationConverter, @Autowired(required=false) JwtAuthenticationConverter jwtAuthenticationConverter) {
        this.jwtDecoder = jwtDecoder;
        this.jwtAuthenticationConverter = jwtAuthenticationConverter;
        this.jwtBearerTokenAuthenticationConverter = jwtBearerTokenAuthenticationConverter;
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) {
    }

    public void preConfigure(HttpSecurity http) throws Exception {
        http.addFilterAfter((Filter)new JwtExceptionOnceFilter(), WebAsyncManagerIntegrationFilter.class);
        OAuth2ResourceServerConfigurer.JwtConfigurer jwt = http.oauth2ResourceServer().accessDeniedHandler((AccessDeniedHandler)new UmsAccessDeniedHandlerImpl()).jwt();
        if (Objects.nonNull(this.jwtAuthenticationConverter)) {
            jwt.jwtAuthenticationConverter((Converter)this.jwtAuthenticationConverter);
        }
        if (Objects.nonNull(this.jwtBearerTokenAuthenticationConverter)) {
            jwt.jwtAuthenticationConverter((Converter)this.jwtBearerTokenAuthenticationConverter);
        }
        jwt.decoder(this.jwtDecoder);
    }

    public void postConfigure(HttpSecurity http) {
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        return null;
    }
}

