/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.utils.ReflectionUtil;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.jwt.JwtContext;
import top.dcenter.ums.security.jwt.claims.service.GenerateClaimsSetService;
import top.dcenter.ums.security.jwt.decoder.UmsNimbusJwtDecoder;
import top.dcenter.ums.security.jwt.enums.JwtRefreshHandlerPolicy;
import top.dcenter.ums.security.jwt.exception.RefreshTokenInvalidException;
import top.dcenter.ums.security.jwt.properties.BearerTokenProperties;
import top.dcenter.ums.security.jwt.properties.JwtProperties;

@Api(tags={"\u5237\u65b0 JWT"})
@Controller
public class JwtRefreshTokenController
implements InitializingBean,
ApplicationContextAware {
    private final GenerateClaimsSetService generateClaimsSetService;
    private final UmsUserDetailsService umsUserDetailsService;
    private final BearerTokenProperties bearerTokenProperties;
    private final String jwtByRefreshTokenUri;
    private final Boolean alwaysRefresh;
    private final UmsNimbusJwtDecoder jwtDecoder;
    private ApplicationContext applicationContext;

    public JwtRefreshTokenController(GenerateClaimsSetService generateClaimsSetService, UmsUserDetailsService umsUserDetailsService, UmsNimbusJwtDecoder jwtDecoder, JwtProperties jwtProperties) {
        if (!JwtRefreshHandlerPolicy.REFRESH_TOKEN.equals(jwtProperties.getRefreshHandlerPolicy())) {
            throw new RuntimeException("ums.jwt.refreshHandlerPolicy != JwtRefreshHandlerPolicy.REFRESH_TOKEN");
        }
        this.generateClaimsSetService = generateClaimsSetService;
        this.umsUserDetailsService = umsUserDetailsService;
        this.jwtDecoder = jwtDecoder;
        this.bearerTokenProperties = jwtProperties.getBearer();
        this.jwtByRefreshTokenUri = jwtProperties.getJwtByRefreshTokenUri();
        this.alwaysRefresh = jwtProperties.getAlwaysRefresh();
    }

    @ApiOperation(value="\u6839\u636e refreshToken \u5237\u65b0 JWT", notes="refreshToken \u7684\u503c\u901a\u8fc7\u6307\u5b9a\u7684\u8bf7\u6c42\u5934\u8fdb\u884c\u4f20\u9012", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(paramType="header", name="Authorization", value="\u901a\u8fc7\u5c5e\u6027 ums.jwt.bearer.bearerTokenHeaderName \u6765\u786e\u5b9a headerName, \u9ed8\u8ba4\u4e3a: Authorization, header \u4e0e form \u4e8c\u9009\u4e00; \u4e0d\u7ba1 jwt \u662f\u5426\u5931\u6548, \u5fc5\u987b\u4f20\u9012\u6b64\u53c2\u6570", example="Authorization: Bearer xxx.xxx.xxx"), @ApiImplicitParam(paramType="form", name="assess_token", value="\u901a\u8fc7\u5c5e\u6027 ums.jwt.bearer.bearerTokenParameterName \u6765\u786e\u5b9a parameterName, \u9ed8\u8ba4\u4e3a: assess_token, header \u4e0e form \u4e8c\u9009\u4e00; \u4e0d\u7ba1 jwt \u662f\u5426\u5931\u6548, \u5fc5\u987b\u4f20\u9012\u6b64\u53c2\u6570", example="assess_token=xxxx.xxxx.xxxx"), @ApiImplicitParam(paramType="header", name="refresh_token", value="\u901a\u8fc7\u5c5e\u6027 ums.jwt.bearer.refreshTokenHeaderName \u6765\u786e\u5b9a headerName, \u9ed8\u8ba4\u4e3a: refresh_token; header \u4e0e form \u4e8c\u9009\u4e00", example="refresh_token: xxxx.xxxx.xxxx"), @ApiImplicitParam(paramType="form", name="refresh_token", value="\u901a\u8fc7\u5c5e\u6027 ums.jwt.bearer.refreshTokenParameterName \u6765\u786e\u5b9a parameterName, \u9ed8\u8ba4\u4e3a: refresh_token; header \u4e0e form \u4e8c\u9009\u4e00", example="refresh_token=xxxx.xxxx.xxxx")})
    @ApiResponses(value={@ApiResponse(responseCode="200", headers={@Header(name="Authorization", description="\u901a\u8fc7\u5c5e\u6027 ums.jwt.bearer.bearerTokenHeaderName \u6765\u786e\u5b9a headerName, \u9ed8\u8ba4\u4e3a: Authorization; \u793a\u4f8b: Authorization: Bearer xxx.xxx.xxx")}, content={@Content(mediaType="application/json;charset=UTF-8", examples={@ExampleObject(name="body", summary="\u6b64 body \u5b9e\u9645\u4e0a\u6ca1\u4ec0\u4e48\u610f\u4e49, \u53ea\u662f\u8868\u793a\u8bf7\u6c42\u6210\u529f, jwt \u503c\u5728 Authorization \u8bf7\u6c42\u5934\u4e0a.", value="{\"code\":0,\"msg\":\"\u5237\u65b0 jwt \u6210\u529f\",\"timestamp\":\"2020-12-17 20:05:32\"}"), @ExampleObject(name="body", summary="\u8868\u793a\u8bf7\u6c42\u6210\u529f, jwt \u503c\u5728 data \u5b57\u6bb5\u4e0a.", value="{\"code\":0,\"msg\":\"\u5237\u65b0 jwt \u6210\u529f\",\"data\":\"xxxx.xxxx.xxxx\",\"timestamp\":\"2020-12-17 20:05:32\"}")})})})
    @RequestMapping(value={"/jwt/refreshToken"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseResult getJwtByRefreshToken(HttpServletRequest request) {
        String refreshToken = JwtContext.getRefreshTokenOrBearerToken(request, this.bearerTokenProperties.getRefreshTokenParameterName(), this.bearerTokenProperties.getRefreshTokenHeaderName());
        if (Objects.isNull(refreshToken)) {
            throw new RefreshTokenInvalidException(ErrorCodeEnum.JWT_REFRESH_TOKEN_NOT_FOUND, MdcUtil.getMdcTraceId());
        }
        Jwt jwt = JwtContext.generateJwtByRefreshToken(refreshToken, this.alwaysRefresh, request, this.jwtDecoder, this.umsUserDetailsService, this.generateClaimsSetService);
        if (this.bearerTokenProperties.getAllowFormEncodedBodyParameter().booleanValue()) {
            return ResponseResult.success((String)"\u5237\u65b0 jwt \u6210\u529f", (Object)jwt.getTokenValue());
        }
        return ResponseResult.success((String)"\u5237\u65b0 jwt \u6210\u529f");
    }

    public void afterPropertiesSet() throws Exception {
        String methodName = "getJwtByRefreshToken";
        ReflectionUtil.setRequestMappingUri((String)methodName, (String)this.jwtByRefreshTokenUri, this.getClass(), (Class[])new Class[]{HttpServletRequest.class});
        ReflectionUtil.registerController((String)"jwtRefreshTokenController", (GenericApplicationContext)((GenericApplicationContext)this.applicationContext), JwtRefreshTokenController.class);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

