/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.decoder;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.proc.SingleKeyJWSKeySelector;
import com.nimbusds.jose.util.Resource;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTProcessor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.security.oauth2.jwt.JwtValidationException;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.MappedJwtClaimSetConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.jwt.JwtContext;
import top.dcenter.ums.security.jwt.api.validator.service.ReAuthService;
import top.dcenter.ums.security.jwt.enums.JwtRefreshHandlerPolicy;
import top.dcenter.ums.security.jwt.exception.JwtInvalidException;

public final class UmsNimbusJwtDecoder
implements JwtDecoder {
    private static final Logger log = LoggerFactory.getLogger(UmsNimbusJwtDecoder.class);
    private static final String DECODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to decode the Jwt: %s";
    private final JWTProcessor<SecurityContext> jwtProcessor;
    private final JwtRefreshHandlerPolicy refreshHandlerPolicy;
    private final Duration remainingRefreshInterval;
    private final String principalClaimName;
    private Converter<Map<String, Object>, Map<String, Object>> claimSetConverter = MappedJwtClaimSetConverter.withDefaults(Collections.emptyMap());
    private OAuth2TokenValidator<Jwt> jwtValidator = JwtValidators.createDefault();
    @Autowired(required=false)
    private ReAuthService reAuthService;

    public UmsNimbusJwtDecoder(JWTProcessor<SecurityContext> jwtProcessor, JwtRefreshHandlerPolicy refreshHandlerPolicy, Duration remainingRefreshInterval, String principalClaimName) {
        Assert.notNull(jwtProcessor, (String)"jwtProcessor cannot be null");
        Assert.notNull((Object)principalClaimName, (String)"principalClaimName cannot be null");
        Assert.notNull((Object)refreshHandlerPolicy, (String)"refreshHandlerPolicy cannot be null");
        Assert.notNull((Object)remainingRefreshInterval, (String)"remainingRefreshInterval cannot be null");
        this.refreshHandlerPolicy = refreshHandlerPolicy;
        this.remainingRefreshInterval = remainingRefreshInterval;
        this.jwtProcessor = jwtProcessor;
        this.principalClaimName = principalClaimName;
    }

    public void setJwtValidator(OAuth2TokenValidator<Jwt> jwtValidator) {
        Assert.notNull(jwtValidator, (String)"jwtValidator cannot be null");
        this.jwtValidator = jwtValidator;
    }

    public void setClaimSetConverter(Converter<Map<String, Object>, Map<String, Object>> claimSetConverter) {
        Assert.notNull(claimSetConverter, (String)"claimSetConverter cannot be null");
        this.claimSetConverter = claimSetConverter;
    }

    public Jwt decode(String token) throws JwtException {
        JWT jwt = this.parse(token);
        if (jwt instanceof PlainJWT) {
            log.trace("Failed to decode unsigned token");
            throw new BadJwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
        }
        Jwt createdJwt = this.createJwt(token, jwt);
        if (JwtRefreshHandlerPolicy.AUTO_RENEW.equals(this.refreshHandlerPolicy)) {
            createdJwt = this.validateJwt(createdJwt);
        }
        if (this.refreshHandlerPolicy.isRefresh(createdJwt, this.remainingRefreshInterval, JwtContext.getClockSkew(), this.reAuthService, this.principalClaimName).booleanValue()) {
            createdJwt = this.refreshHandlerPolicy.refreshHandle(createdJwt, this, this.principalClaimName);
        }
        if (!JwtRefreshHandlerPolicy.AUTO_RENEW.equals(this.refreshHandlerPolicy)) {
            createdJwt = this.validateJwt(createdJwt);
        }
        return createdJwt;
    }

    public Jwt decodeNotRefreshToken(String token) throws JwtException {
        JWT jwt = this.parse(token);
        if (jwt instanceof PlainJWT) {
            log.trace("Failed to decode unsigned token");
            throw new BadJwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
        }
        Jwt createdJwt = this.createJwt(token, jwt);
        createdJwt = this.validateJwt(createdJwt);
        return createdJwt;
    }

    public Jwt decodeNotValidate(String token) throws JwtInvalidException {
        try {
            JWT parsedJwt = JWTParser.parse((String)token);
            JWTClaimsSet jwtClaimsSet = parsedJwt.getJWTClaimsSet();
            LinkedHashMap headers = new LinkedHashMap(parsedJwt.getHeader().toJSONObject());
            Map claims = (Map)this.claimSetConverter.convert((Object)jwtClaimsSet.getClaims());
            Objects.requireNonNull(claims, "\u8f6c\u6362 jwtClaimsSet \u5230 claims \u662f\u8fd4\u56de null \u503c");
            return Jwt.withTokenValue((String)token).headers(h -> h.putAll(headers)).claims(c -> c.putAll(claims)).build();
        }
        catch (Exception ex) {
            log.error("\u8f6c\u6362 token \u5230 Jwt \u65f6\u53d1\u751f\u9519\u8bef", (Throwable)ex);
            throw new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
        }
    }

    public Jwt decodeRefreshTokenOfJwt(String token) throws JwtInvalidException {
        try {
            JWT parsedJwt = JWTParser.parse((String)token);
            JWTClaimsSet jwtClaimsSet = this.jwtProcessor.process(parsedJwt, null);
            LinkedHashMap headers = new LinkedHashMap(parsedJwt.getHeader().toJSONObject());
            Map claims = (Map)this.claimSetConverter.convert((Object)jwtClaimsSet.getClaims());
            Objects.requireNonNull(claims, "\u8f6c\u6362 jwtClaimsSet \u5230 claims \u662f\u8fd4\u56de null \u503c");
            Jwt createJwt = Jwt.withTokenValue((String)token).headers(h -> h.putAll(headers)).claims(c -> c.putAll(claims)).build();
            Instant expiresAt = createJwt.getExpiresAt();
            if (Objects.nonNull(expiresAt) && Instant.now().minusSeconds(JwtContext.getClockSkew().getSeconds()).isAfter(expiresAt)) {
                throw new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
            }
            if (JwtContext.refreshJwtInTheBlacklist(createJwt, this.principalClaimName).booleanValue()) {
                throw new JwtInvalidException(ErrorCodeEnum.JWT_REFRESH_TOKEN_INVALID, MdcUtil.getMdcTraceId());
            }
            if (this.reAuthService.isReAuth(createJwt).booleanValue()) {
                JwtContext.addBlacklistForRefreshToken(createJwt, this.principalClaimName);
                throw new JwtInvalidException(ErrorCodeEnum.JWT_RE_AUTH, MdcUtil.getMdcTraceId());
            }
            return createJwt;
        }
        catch (JwtInvalidException ex) {
            log.error("\u56e0\u9700\u8981\u91cd\u65b0\u8ba4\u8bc1, refresh token \u5931\u6548", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("\u8f6c\u6362 token \u5230 Jwt \u65f6\u53d1\u751f\u9519\u8bef", (Throwable)ex);
            throw new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
        }
    }

    private JWT parse(String token) {
        try {
            return JWTParser.parse((String)token);
        }
        catch (Exception ex) {
            log.trace("Failed to parse token", (Throwable)ex);
            throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), (Throwable)ex);
        }
    }

    private Jwt createJwt(String token, JWT parsedJwt) {
        try {
            JWTClaimsSet jwtClaimsSet = this.jwtProcessor.process(parsedJwt, null);
            LinkedHashMap headers = new LinkedHashMap(parsedJwt.getHeader().toJSONObject());
            Map claims = (Map)this.claimSetConverter.convert((Object)jwtClaimsSet.getClaims());
            return Jwt.withTokenValue((String)token).headers(h -> h.putAll(headers)).claims(c -> c.putAll(claims)).build();
        }
        catch (RemoteKeySourceException ex) {
            log.trace("Failed to retrieve JWK set", (Throwable)ex);
            if (ex.getCause() instanceof ParseException) {
                throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed Jwk set"));
            }
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), (Throwable)ex);
        }
        catch (JOSEException ex) {
            log.trace("Failed to process JWT", (Throwable)ex);
            throw new JwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            log.trace("Failed to process JWT", (Throwable)ex);
            if (ex.getCause() instanceof ParseException) {
                throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, "Malformed payload"));
            }
            throw new BadJwtException(String.format(DECODING_ERROR_MESSAGE_TEMPLATE, ex.getMessage()), (Throwable)ex);
        }
    }

    private Jwt validateJwt(Jwt jwt) {
        Jwt refreshJwt = this.validateJti(jwt);
        if (!Objects.equals(refreshJwt, jwt)) {
            return refreshJwt;
        }
        OAuth2TokenValidatorResult result = this.jwtValidator.validate((AbstractOAuth2Token)jwt);
        if (result.hasErrors()) {
            Collection errors = result.getErrors();
            String validationErrorString = this.getJwtValidationExceptionMessage(errors);
            throw new JwtValidationException(validationErrorString, errors);
        }
        return jwt;
    }

    private Jwt validateJti(Jwt jwt) {
        JwtContext.BlacklistType blacklistType = JwtContext.jtiInTheBlacklist(jwt.getId());
        try {
            String newJwtString = JwtContext.inBlacklistAndHasNewJwt(blacklistType);
            if (Objects.nonNull(newJwtString)) {
                return this.decodeNotValidate(newJwtString);
            }
            return jwt;
        }
        catch (JwtInvalidException e) {
            OAuth2TokenValidatorResult result = OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_request", "The jti claim is not valid", null)});
            Collection errors = result.getErrors();
            String validationErrorString = this.getJwtValidationExceptionMessage(errors);
            throw new JwtValidationException(validationErrorString, errors);
        }
    }

    private String getJwtValidationExceptionMessage(Collection<OAuth2Error> errors) {
        for (OAuth2Error oAuth2Error : errors) {
            if (StringUtils.isEmpty((Object)oAuth2Error.getDescription())) continue;
            return String.format(DECODING_ERROR_MESSAGE_TEMPLATE, oAuth2Error.getDescription());
        }
        return "Unable to validate Jwt";
    }

    public static JwkSetUriJwtDecoderBuilder withJwkSetUri(String jwkSetUri, JwtRefreshHandlerPolicy refreshHandlerPolicy, Duration remainingRefreshInterval, String principalClaimName) {
        return new JwkSetUriJwtDecoderBuilder(jwkSetUri, refreshHandlerPolicy, remainingRefreshInterval, principalClaimName);
    }

    public static PublicKeyJwtDecoderBuilder withPublicKey(RSAPublicKey key, JwtRefreshHandlerPolicy refreshHandlerPolicy, Duration remainingRefreshInterval, String principalClaimName) {
        return new PublicKeyJwtDecoderBuilder(key, refreshHandlerPolicy, remainingRefreshInterval, principalClaimName);
    }

    public static SecretKeyJwtDecoderBuilder withSecretKey(SecretKey secretKey, JwtRefreshHandlerPolicy refreshHandlerPolicy, Duration remainingRefreshInterval, String principalClaimName) {
        return new SecretKeyJwtDecoderBuilder(secretKey, refreshHandlerPolicy, remainingRefreshInterval, principalClaimName);
    }

    public Duration getRemainingRefreshInterval() {
        return this.remainingRefreshInterval;
    }

    public String getPrincipalClaimName() {
        return this.principalClaimName;
    }

    public static final class SecretKeyJwtDecoderBuilder {
        private final SecretKey secretKey;
        private final JwtRefreshHandlerPolicy refreshHandlerPolicy;
        private final Duration remainingRefreshInterval;
        private final String principalClaimName;
        private JWSAlgorithm jwsAlgorithm = JWSAlgorithm.HS256;
        private Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer;

        private SecretKeyJwtDecoderBuilder(SecretKey secretKey, JwtRefreshHandlerPolicy refreshHandlerPolicy, Duration remainingRefreshInterval, String principalClaimName) {
            Assert.notNull((Object)secretKey, (String)"secretKey cannot be null");
            Assert.notNull((Object)refreshHandlerPolicy, (String)"refreshHandlerPolicy cannot be null");
            Assert.notNull((Object)remainingRefreshInterval, (String)"remainingRefreshInterval cannot be null");
            Assert.notNull((Object)principalClaimName, (String)"principalClaimName cannot be null");
            this.principalClaimName = principalClaimName;
            this.secretKey = secretKey;
            this.refreshHandlerPolicy = refreshHandlerPolicy;
            this.remainingRefreshInterval = remainingRefreshInterval;
            this.jwtProcessorCustomizer = processor -> {};
        }

        public SecretKeyJwtDecoderBuilder macAlgorithm(MacAlgorithm macAlgorithm) {
            Assert.notNull((Object)macAlgorithm, (String)"macAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)macAlgorithm.getName());
            return this;
        }

        public SecretKeyJwtDecoderBuilder jwtProcessorCustomizer(Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer) {
            Assert.notNull(jwtProcessorCustomizer, (String)"jwtProcessorCustomizer cannot be null");
            this.jwtProcessorCustomizer = jwtProcessorCustomizer;
            return this;
        }

        public UmsNimbusJwtDecoder build() {
            return new UmsNimbusJwtDecoder(this.processor(), this.refreshHandlerPolicy, this.remainingRefreshInterval, this.principalClaimName);
        }

        JWTProcessor<SecurityContext> processor() {
            SingleKeyJWSKeySelector jwsKeySelector = new SingleKeyJWSKeySelector(this.jwsAlgorithm, (Key)this.secretKey);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            this.jwtProcessorCustomizer.accept((ConfigurableJWTProcessor<SecurityContext>)jwtProcessor);
            return jwtProcessor;
        }
    }

    public static final class PublicKeyJwtDecoderBuilder {
        private JWSAlgorithm jwsAlgorithm;
        private final String principalClaimName;
        private final RSAPublicKey key;
        private final JwtRefreshHandlerPolicy refreshHandlerPolicy;
        private final Duration remainingRefreshInterval;
        private Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer;

        private PublicKeyJwtDecoderBuilder(RSAPublicKey key, JwtRefreshHandlerPolicy refreshHandlerPolicy, Duration remainingRefreshInterval, String principalClaimName) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            Assert.notNull((Object)refreshHandlerPolicy, (String)"refreshHandlerPolicy cannot be null");
            Assert.notNull((Object)remainingRefreshInterval, (String)"remainingRefreshInterval cannot be null");
            Assert.notNull((Object)principalClaimName, (String)"principalClaimName cannot be null");
            this.principalClaimName = principalClaimName;
            this.jwsAlgorithm = JWSAlgorithm.RS256;
            this.key = key;
            this.refreshHandlerPolicy = refreshHandlerPolicy;
            this.remainingRefreshInterval = remainingRefreshInterval;
            this.jwtProcessorCustomizer = processor -> {};
        }

        public PublicKeyJwtDecoderBuilder signatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"signatureAlgorithm cannot be null");
            this.jwsAlgorithm = JWSAlgorithm.parse((String)signatureAlgorithm.getName());
            return this;
        }

        public PublicKeyJwtDecoderBuilder jwtProcessorCustomizer(Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer) {
            Assert.notNull(jwtProcessorCustomizer, (String)"jwtProcessorCustomizer cannot be null");
            this.jwtProcessorCustomizer = jwtProcessorCustomizer;
            return this;
        }

        JWTProcessor<SecurityContext> processor() {
            Assert.state((boolean)JWSAlgorithm.Family.RSA.contains((Object)this.jwsAlgorithm), () -> "The provided key is of type RSA; however the signature algorithm is of some other type: " + this.jwsAlgorithm + ". Please indicate one of RS256, RS384, or RS512.");
            SingleKeyJWSKeySelector jwsKeySelector = new SingleKeyJWSKeySelector(this.jwsAlgorithm, (Key)this.key);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            this.jwtProcessorCustomizer.accept((ConfigurableJWTProcessor<SecurityContext>)jwtProcessor);
            return jwtProcessor;
        }

        public UmsNimbusJwtDecoder build() {
            return new UmsNimbusJwtDecoder(this.processor(), this.refreshHandlerPolicy, this.remainingRefreshInterval, this.principalClaimName);
        }
    }

    public static final class JwkSetUriJwtDecoderBuilder {
        private final String jwkSetUri;
        private final JwtRefreshHandlerPolicy refreshHandlerPolicy;
        private final Duration remainingRefreshInterval;
        private final String principalClaimName;
        private Set<SignatureAlgorithm> signatureAlgorithms = new HashSet<SignatureAlgorithm>();
        private RestOperations restOperations = new RestTemplate();
        private Cache cache;
        private Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer;

        private JwkSetUriJwtDecoderBuilder(String jwkSetUri, JwtRefreshHandlerPolicy refreshHandlerPolicy, Duration remainingRefreshInterval, String principalClaimName) {
            Assert.hasText((String)jwkSetUri, (String)"jwkSetUri cannot be empty");
            Assert.notNull((Object)refreshHandlerPolicy, (String)"refreshHandlerPolicy cannot be null");
            Assert.notNull((Object)remainingRefreshInterval, (String)"remainingRefreshInterval cannot be null");
            Assert.notNull((Object)principalClaimName, (String)"principalClaimName cannot be null");
            this.principalClaimName = principalClaimName;
            this.jwkSetUri = jwkSetUri;
            this.refreshHandlerPolicy = refreshHandlerPolicy;
            this.remainingRefreshInterval = remainingRefreshInterval;
            this.jwtProcessorCustomizer = processor -> {};
        }

        public JwkSetUriJwtDecoderBuilder jwsAlgorithm(SignatureAlgorithm signatureAlgorithm) {
            Assert.notNull((Object)signatureAlgorithm, (String)"signatureAlgorithm cannot be null");
            this.signatureAlgorithms.add(signatureAlgorithm);
            return this;
        }

        public JwkSetUriJwtDecoderBuilder jwsAlgorithms(Consumer<Set<SignatureAlgorithm>> signatureAlgorithmsConsumer) {
            Assert.notNull(signatureAlgorithmsConsumer, (String)"signatureAlgorithmsConsumer cannot be null");
            signatureAlgorithmsConsumer.accept(this.signatureAlgorithms);
            return this;
        }

        public JwkSetUriJwtDecoderBuilder restOperations(RestOperations restOperations) {
            Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
            this.restOperations = restOperations;
            return this;
        }

        public JwkSetUriJwtDecoderBuilder cache(Cache cache) {
            Assert.notNull((Object)cache, (String)"cache cannot be null");
            this.cache = cache;
            return this;
        }

        public JwkSetUriJwtDecoderBuilder jwtProcessorCustomizer(Consumer<ConfigurableJWTProcessor<SecurityContext>> jwtProcessorCustomizer) {
            Assert.notNull(jwtProcessorCustomizer, (String)"jwtProcessorCustomizer cannot be null");
            this.jwtProcessorCustomizer = jwtProcessorCustomizer;
            return this;
        }

        JWSKeySelector<SecurityContext> jwsKeySelector(JWKSource<SecurityContext> jwkSource) {
            if (this.signatureAlgorithms.isEmpty()) {
                return new JWSVerificationKeySelector(JWSAlgorithm.RS256, jwkSource);
            }
            HashSet<JWSAlgorithm> jwsAlgorithms = new HashSet<JWSAlgorithm>();
            for (SignatureAlgorithm signatureAlgorithm : this.signatureAlgorithms) {
                JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)signatureAlgorithm.getName());
                jwsAlgorithms.add(jwsAlgorithm);
            }
            return new JWSVerificationKeySelector(jwsAlgorithms, jwkSource);
        }

        JWKSource<SecurityContext> jwkSource(ResourceRetriever jwkSetRetriever) {
            if (this.cache == null) {
                return new RemoteJWKSet(JwkSetUriJwtDecoderBuilder.toURL(this.jwkSetUri), jwkSetRetriever);
            }
            CachingResourceRetriever cachingJwkSetRetriever = new CachingResourceRetriever(this.cache, jwkSetRetriever);
            return new RemoteJWKSet(JwkSetUriJwtDecoderBuilder.toURL(this.jwkSetUri), (ResourceRetriever)cachingJwkSetRetriever, (JWKSetCache)new NoOpJwkSetCache());
        }

        JWTProcessor<SecurityContext> processor() {
            RestOperationsResourceRetriever jwkSetRetriever = new RestOperationsResourceRetriever(this.restOperations);
            JWKSource<SecurityContext> jwkSource = this.jwkSource(jwkSetRetriever);
            DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
            jwtProcessor.setJWSKeySelector(this.jwsKeySelector(jwkSource));
            jwtProcessor.setJWTClaimsSetVerifier((claims, context) -> {});
            this.jwtProcessorCustomizer.accept((ConfigurableJWTProcessor<SecurityContext>)jwtProcessor);
            return jwtProcessor;
        }

        public UmsNimbusJwtDecoder build() {
            return new UmsNimbusJwtDecoder(this.processor(), this.refreshHandlerPolicy, this.remainingRefreshInterval, this.principalClaimName);
        }

        private static URL toURL(String url) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Invalid JWK Set URL \"" + url + "\" : " + ex.getMessage(), ex);
            }
        }

        private static class RestOperationsResourceRetriever
        implements ResourceRetriever {
            private static final MediaType APPLICATION_JWK_SET_JSON = new MediaType("application", "jwk-set+json");
            private final RestOperations restOperations;

            RestOperationsResourceRetriever(RestOperations restOperations) {
                Assert.notNull((Object)restOperations, (String)"restOperations cannot be null");
                this.restOperations = restOperations;
            }

            public Resource retrieveResource(URL url) throws IOException {
                HttpHeaders headers = new HttpHeaders();
                headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON, APPLICATION_JWK_SET_JSON));
                ResponseEntity<String> response = this.getResponse(url, headers);
                if (response.getStatusCodeValue() != 200) {
                    throw new IOException(response.toString());
                }
                return new Resource((String)response.getBody(), "UTF-8");
            }

            private ResponseEntity<String> getResponse(URL url, HttpHeaders headers) throws IOException {
                try {
                    RequestEntity request = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, url.toURI());
                    return this.restOperations.exchange(request, String.class);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
        }

        private static class CachingResourceRetriever
        implements ResourceRetriever {
            private final Cache cache;
            private final ResourceRetriever resourceRetriever;

            CachingResourceRetriever(Cache cache, ResourceRetriever resourceRetriever) {
                this.cache = cache;
                this.resourceRetriever = resourceRetriever;
            }

            public Resource retrieveResource(URL url) throws IOException {
                try {
                    String jwkSet = (String)this.cache.get((Object)url.toString(), () -> this.resourceRetriever.retrieveResource(url).getContent());
                    return new Resource(jwkSet, "UTF-8");
                }
                catch (Cache.ValueRetrievalException ex) {
                    Throwable thrownByValueLoader = ex.getCause();
                    if (thrownByValueLoader instanceof IOException) {
                        throw (IOException)thrownByValueLoader;
                    }
                    throw new IOException(thrownByValueLoader);
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
        }

        private static class NoOpJwkSetCache
        implements JWKSetCache {
            private NoOpJwkSetCache() {
            }

            public void put(JWKSet jwkSet) {
            }

            public JWKSet get() {
                return null;
            }

            public boolean requiresRefresh() {
                return true;
            }
        }
    }
}

