/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.endpoint;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.minidev.json.JSONObject;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.utils.ReflectionUtil;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.jwt.api.endpoind.service.JwkEndpointPermissionService;
import top.dcenter.ums.security.jwt.exception.JwkSetUriAccessDeniedException;

@ResponseBody
public class JwkEndpoint
implements InitializingBean,
ApplicationContextAware {
    public static final String JWS_SET_URI = "/.well-known/jwks.json";
    private final String jwsSetJsonString;
    private final JwkEndpointPermissionService jwkEndpointPermissionService;
    private ApplicationContext applicationContext;

    public JwkEndpoint(@NonNull RSAPublicKey rsaPublicKey, @NonNull String jksAlgorithm, @NonNull JwkEndpointPermissionService jwkEndpointPermissionService, @Nullable String kid) {
        this.jwkEndpointPermissionService = jwkEndpointPermissionService;
        RSAKey key = new RSAKey.Builder(rsaPublicKey).build();
        JSONObject jsonObject = new JWKSet((JWK)key).toJSONObject();
        Map publicKey = (Map)((List)jsonObject.get((Object)"keys")).get(0);
        publicKey.put("alg", jksAlgorithm);
        if (StringUtils.hasText((String)kid)) {
            publicKey.put("kid", kid);
        }
        this.jwsSetJsonString = jsonObject.toJSONString();
    }

    @RequestMapping(path={"/.well-known/jwks.json"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getKey(HttpServletRequest request) {
        if (!this.jwkEndpointPermissionService.hasPermission(request).booleanValue()) {
            throw new JwkSetUriAccessDeniedException(ErrorCodeEnum.NOT_FOUND, MdcUtil.getMdcTraceId());
        }
        return this.jwsSetJsonString;
    }

    public void afterPropertiesSet() throws Exception {
        ReflectionUtil.registerController((String)"jwkEndpoint", (GenericApplicationContext)((GenericApplicationContext)this.applicationContext), JwkEndpoint.class);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

