/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.enums;

import com.nimbusds.jose.JOSEException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.jwt.Jwt;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.jwt.JwtContext;
import top.dcenter.ums.security.jwt.api.validator.service.ReAuthService;
import top.dcenter.ums.security.jwt.decoder.UmsNimbusJwtDecoder;
import top.dcenter.ums.security.jwt.exception.JwtExpiredException;
import top.dcenter.ums.security.jwt.exception.JwtInvalidException;
import top.dcenter.ums.security.jwt.exception.JwtReAuthException;
import top.dcenter.ums.security.jwt.handler.JwtRefreshHandler;

public enum JwtRefreshHandlerPolicy implements JwtRefreshHandler
{
    AUTO_RENEW{

        @Override
        @NonNull
        public Boolean isRefresh(@NonNull Jwt jwt, @NonNull Duration remainingRefreshInterval, @NonNull Duration clockSkew, @Nullable ReAuthService reAuthService, @NonNull String principalClaimName) throws JwtInvalidException, JwtReAuthException {
            Instant expiresAt = JwtRefreshHandlerPolicy.check(jwt, reAuthService, principalClaimName);
            long nowOfClockShew = Instant.now().minusSeconds(clockSkew.getSeconds()).getEpochSecond();
            long remainingSecond = expiresAt.getEpochSecond() - nowOfClockShew;
            if (remainingSecond < 0L) {
                throw new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
            }
            return remainingSecond < remainingRefreshInterval.getSeconds();
        }

        @Override
        @NonNull
        public Jwt refreshHandle(@NonNull Jwt jwt, @NonNull UmsNimbusJwtDecoder jwtDecoder, @NonNull String principalClaimName) throws JwtInvalidException {
            Jwt resetJwt;
            try {
                resetJwt = JwtContext.resetJwtExpOfAutoRenewPolicy(jwt, jwtDecoder, this, principalClaimName);
            }
            catch (JOSEException | ParseException e) {
                log.error(e.getMessage(), e);
                try {
                    resetJwt = JwtContext.resetJwtExpOfAutoRenewPolicy(jwt, jwtDecoder, this, principalClaimName);
                }
                catch (Exception ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    throw new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
                }
            }
            return resetJwt;
        }
    }
    ,
    REFRESH_TOKEN{

        @Override
        @NonNull
        public Boolean isRefresh(@NonNull Jwt jwt, @NonNull Duration remainingRefreshInterval, @NonNull Duration clockSkew, @Nullable ReAuthService reAuthService, @NonNull String principalClaimName) throws JwtInvalidException, JwtReAuthException {
            Instant expiresAt = JwtRefreshHandlerPolicy.check(jwt, reAuthService, principalClaimName);
            return Instant.now().minusSeconds(clockSkew.getSeconds()).isAfter(expiresAt);
        }

        @Override
        @NonNull
        public Jwt refreshHandle(@NonNull Jwt jwt, @NonNull UmsNimbusJwtDecoder jwtDecoder, @NonNull String principalClaimName) throws JwtExpiredException {
            throw new JwtExpiredException(ErrorCodeEnum.JWT_EXPIRED, MdcUtil.getMdcTraceId());
        }
    }
    ,
    REJECT{

        @Override
        @NonNull
        public Boolean isRefresh(@NonNull Jwt jwt, @NonNull Duration remainingRefreshInterval, @NonNull Duration clockSkew, @Nullable ReAuthService reAuthService, @NonNull String principalClaimName) throws JwtInvalidException, JwtReAuthException {
            Instant expiresAt = JwtRefreshHandlerPolicy.check(jwt, reAuthService, principalClaimName);
            return Instant.now().minusSeconds(clockSkew.getSeconds()).isAfter(expiresAt);
        }

        @Override
        @NonNull
        public Jwt refreshHandle(@NonNull Jwt jwt, @NonNull UmsNimbusJwtDecoder jwtDecoder, @NonNull String principalClaimName) throws JwtInvalidException {
            throw new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
        }
    };

    private static final Logger log;

    @NonNull
    private static Instant check(@NonNull Jwt jwt, @Nullable ReAuthService reAuthService, @NonNull String principalClaimName) throws JwtInvalidException, JwtReAuthException {
        Instant expiresAt = jwt.getExpiresAt();
        if (Objects.isNull(expiresAt)) {
            throw new JwtInvalidException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
        }
        if (Objects.nonNull(reAuthService) && reAuthService.isReAuth(jwt).booleanValue()) {
            JwtContext.addBlacklistForReAuth(jwt, principalClaimName);
            throw new JwtReAuthException(ErrorCodeEnum.JWT_INVALID, MdcUtil.getMdcTraceId());
        }
        return expiresAt;
    }

    static {
        log = LoggerFactory.getLogger(JwtRefreshHandlerPolicy.class);
    }
}

