/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.NestedServletException;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;
import top.dcenter.ums.security.jwt.exception.BaseJwtException;
import top.dcenter.ums.security.jwt.exception.BaseUmsJwtException;
import top.dcenter.ums.security.jwt.exception.DuplicateRefreshTokenException;
import top.dcenter.ums.security.jwt.exception.JwkSetUriAccessDeniedException;
import top.dcenter.ums.security.jwt.exception.JwtCreateException;
import top.dcenter.ums.security.jwt.exception.JwtExpiredException;
import top.dcenter.ums.security.jwt.exception.JwtInvalidException;
import top.dcenter.ums.security.jwt.exception.JwtReAuthException;
import top.dcenter.ums.security.jwt.exception.MismatchRefreshJwtPolicyException;
import top.dcenter.ums.security.jwt.exception.RefreshTokenInvalidException;
import top.dcenter.ums.security.jwt.exception.RefreshTokenNotFoundException;
import top.dcenter.ums.security.jwt.exception.SaveRefreshTokenException;

public class JwtExceptionOnceFilter
extends OncePerRequestFilter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (JwtReAuthException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.UNAUTHORIZED.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)ErrorCodeEnum.JWT_RE_AUTH.getMsg(), (ErrorCodeEnum)ErrorCodeEnum.JWT_RE_AUTH, (Object)MdcUtil.getMdcTraceId())));
        }
        catch (JwkSetUriAccessDeniedException e) {
            this.log.error(e.getMessage(), (Throwable)((Object)e));
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.NOT_FOUND.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)e.getMessage(), (ErrorCodeEnum)e.getErrorCodeEnum(), (Object)e.getData())));
        }
        catch (JwtCreateException | SaveRefreshTokenException e) {
            this.log.error(e.getMessage(), (Throwable)((Object)e));
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)e.getMessage(), (ErrorCodeEnum)e.getErrorCodeEnum(), (Object)e.getData())));
        }
        catch (InvalidBearerTokenException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.UNAUTHORIZED.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)ErrorCodeEnum.JWT_INVALID.getMsg(), (ErrorCodeEnum)ErrorCodeEnum.JWT_INVALID, (Object)MdcUtil.getMdcTraceId())));
        }
        catch (DuplicateRefreshTokenException | JwtExpiredException | JwtInvalidException | MismatchRefreshJwtPolicyException | RefreshTokenInvalidException | RefreshTokenNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.UNAUTHORIZED.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)e.getMessage(), (ErrorCodeEnum)e.getErrorCodeEnum(), (Object)e.getData())));
        }
        catch (NestedServletException e) {
            Throwable cause = e.getCause();
            if (cause instanceof JwtReAuthException) {
                JwtReAuthException exception = (JwtReAuthException)cause;
                this.log.error(exception.getMessage(), (Throwable)exception);
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.UNAUTHORIZED.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)exception.getMessage(), (ErrorCodeEnum)exception.getErrorCodeEnum(), (Object)exception.getData())));
                return;
            }
            if (cause instanceof BaseUmsJwtException) {
                BaseUmsJwtException exception = (BaseUmsJwtException)cause;
                this.log.error(exception.getMessage(), (Throwable)exception);
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.UNAUTHORIZED.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)exception.getMessage(), (ErrorCodeEnum)exception.getErrorCodeEnum(), (Object)exception.getData())));
                return;
            }
            if (cause instanceof JwkSetUriAccessDeniedException) {
                JwkSetUriAccessDeniedException exception = (JwkSetUriAccessDeniedException)((Object)cause);
                this.log.error(exception.getMessage(), (Throwable)((Object)exception));
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.NOT_FOUND.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)exception.getMessage(), (ErrorCodeEnum)exception.getErrorCodeEnum(), (Object)exception.getData())));
                return;
            }
            if (cause instanceof BaseJwtException) {
                BaseJwtException exception = (BaseJwtException)((Object)cause);
                this.log.error(exception.getMessage(), (Throwable)((Object)exception));
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)exception.getMessage(), (ErrorCodeEnum)exception.getErrorCodeEnum(), (Object)exception.getData())));
                return;
            }
            if (cause instanceof InvalidBearerTokenException) {
                InvalidBearerTokenException exception = (InvalidBearerTokenException)cause;
                this.log.error(exception.getMessage(), (Throwable)exception);
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.UNAUTHORIZED.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.fail((String)ErrorCodeEnum.JWT_INVALID.getMsg(), (ErrorCodeEnum)ErrorCodeEnum.JWT_INVALID, (Object)MdcUtil.getMdcTraceId())));
                return;
            }
            throw e;
        }
    }
}

