/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.properties;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import top.dcenter.ums.security.jwt.enums.JwtRefreshHandlerPolicy;
import top.dcenter.ums.security.jwt.properties.BearerTokenProperties;
import top.dcenter.ums.security.jwt.properties.JwtBlacklistProperties;

@ConfigurationProperties(prefix="ums.jwt")
public class JwtProperties {
    @NestedConfigurationProperty
    public final BearerTokenProperties bearer = new BearerTokenProperties();
    @NestedConfigurationProperty
    public final JwtBlacklistProperties blacklist = new JwtBlacklistProperties();
    public static final int MACS_SECRET_LENGTH = 32;
    private Boolean enable = Boolean.FALSE;
    private Duration timeout = Duration.ofHours(1L);
    private Duration clockSkew = Duration.ofSeconds(0L);
    private Duration remainingRefreshInterval = Duration.ofSeconds(600L);
    private Boolean alwaysRefresh = Boolean.FALSE;
    private JwtRefreshHandlerPolicy refreshHandlerPolicy = JwtRefreshHandlerPolicy.REJECT;
    private String jwtByRefreshTokenUri = "/jwt/refreshToken";
    private Boolean exposeRefreshTokenUri = Boolean.FALSE;
    private Boolean exposeJwkSetUri = Boolean.FALSE;
    private String jwsAlgorithms = "RS256";
    private String macsSecret;
    private Resource jksKeyPairLocation;
    private String jksAlias;
    private String jksPassword;
    private String principalClaimName = "sub";
    private String kid;
    private String iss;

    public String readJksKeyPair() throws IOException {
        String key = "ums.jwt.jks-key-pair-location";
        Assert.notNull((Object)this.jksKeyPairLocation, (String)"jksKeyPairLocation must not be null");
        if (!this.jksKeyPairLocation.exists()) {
            throw new InvalidConfigurationPropertyValueException(key, (Object)this.jksKeyPairLocation, "jks key location does not exist");
        }
        try (InputStream inputStream = this.jksKeyPairLocation.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public BearerTokenProperties getBearer() {
        return this.bearer;
    }

    public JwtBlacklistProperties getBlacklist() {
        return this.blacklist;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Duration getClockSkew() {
        return this.clockSkew;
    }

    public Duration getRemainingRefreshInterval() {
        return this.remainingRefreshInterval;
    }

    public Boolean getAlwaysRefresh() {
        return this.alwaysRefresh;
    }

    public JwtRefreshHandlerPolicy getRefreshHandlerPolicy() {
        return this.refreshHandlerPolicy;
    }

    public String getJwtByRefreshTokenUri() {
        return this.jwtByRefreshTokenUri;
    }

    public Boolean getExposeRefreshTokenUri() {
        return this.exposeRefreshTokenUri;
    }

    public Boolean getExposeJwkSetUri() {
        return this.exposeJwkSetUri;
    }

    public String getJwsAlgorithms() {
        return this.jwsAlgorithms;
    }

    public String getMacsSecret() {
        return this.macsSecret;
    }

    public Resource getJksKeyPairLocation() {
        return this.jksKeyPairLocation;
    }

    public String getJksAlias() {
        return this.jksAlias;
    }

    public String getJksPassword() {
        return this.jksPassword;
    }

    public String getPrincipalClaimName() {
        return this.principalClaimName;
    }

    public String getKid() {
        return this.kid;
    }

    public String getIss() {
        return this.iss;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public void setClockSkew(Duration clockSkew) {
        this.clockSkew = clockSkew;
    }

    public void setRemainingRefreshInterval(Duration remainingRefreshInterval) {
        this.remainingRefreshInterval = remainingRefreshInterval;
    }

    public void setAlwaysRefresh(Boolean alwaysRefresh) {
        this.alwaysRefresh = alwaysRefresh;
    }

    public void setRefreshHandlerPolicy(JwtRefreshHandlerPolicy refreshHandlerPolicy) {
        this.refreshHandlerPolicy = refreshHandlerPolicy;
    }

    public void setJwtByRefreshTokenUri(String jwtByRefreshTokenUri) {
        this.jwtByRefreshTokenUri = jwtByRefreshTokenUri;
    }

    public void setExposeRefreshTokenUri(Boolean exposeRefreshTokenUri) {
        this.exposeRefreshTokenUri = exposeRefreshTokenUri;
    }

    public void setExposeJwkSetUri(Boolean exposeJwkSetUri) {
        this.exposeJwkSetUri = exposeJwkSetUri;
    }

    public void setJwsAlgorithms(String jwsAlgorithms) {
        this.jwsAlgorithms = jwsAlgorithms;
    }

    public void setMacsSecret(String macsSecret) {
        this.macsSecret = macsSecret;
    }

    public void setJksKeyPairLocation(Resource jksKeyPairLocation) {
        this.jksKeyPairLocation = jksKeyPairLocation;
    }

    public void setJksAlias(String jksAlias) {
        this.jksAlias = jksAlias;
    }

    public void setJksPassword(String jksPassword) {
        this.jksPassword = jksPassword;
    }

    public void setPrincipalClaimName(String principalClaimName) {
        this.principalClaimName = principalClaimName;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public void setIss(String iss) {
        this.iss = iss;
    }
}

