/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.resolver;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.BearerTokenErrors;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.utils.UrlUtil;

public final class UmsBearerTokenResolver
implements BearerTokenResolver {
    private static final Pattern AUTHORIZATION_PATTERN = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-._~+/]+=*)$", 2);
    private final String requestParameterName;
    private boolean allowFormEncodedBodyParameter = false;
    private boolean allowUriQueryParameter = false;
    private String bearerTokenHeaderName = "Authorization";
    private final Set<String> ignoreUrls = new HashSet<String>();
    private final AntPathMatcher matcher = new AntPathMatcher();

    public UmsBearerTokenResolver(@NonNull String requestParameterName, @Nullable String jwtByRefreshTokenUri) {
        this.requestParameterName = requestParameterName;
        this.ignoreUrls.add(jwtByRefreshTokenUri);
    }

    public String resolve(HttpServletRequest request) {
        String pathWithinApplication = UrlUtil.getUrlPathHelper().getPathWithinApplication(request);
        boolean anyMatch = this.ignoreUrls.stream().anyMatch(ignoreUrl -> this.matcher.match(ignoreUrl, pathWithinApplication));
        if (anyMatch) {
            return null;
        }
        String authorizationHeaderToken = this.resolveFromAuthorizationHeader(request);
        String parameterToken = this.resolveFromRequestParameters(request);
        if (authorizationHeaderToken != null) {
            if (parameterToken != null) {
                BearerTokenError error = BearerTokenErrors.invalidRequest((String)"Found multiple bearer tokens in the request");
                throw new OAuth2AuthenticationException((OAuth2Error)error);
            }
            return authorizationHeaderToken;
        }
        if (parameterToken != null && this.isParameterTokenSupportedForRequest(request)) {
            return parameterToken;
        }
        return null;
    }

    public void addIgnoreUrls(Set<String> ignoreUrls) {
        this.ignoreUrls.addAll(ignoreUrls);
    }

    public void setAllowFormEncodedBodyParameter(boolean allowFormEncodedBodyParameter) {
        this.allowFormEncodedBodyParameter = allowFormEncodedBodyParameter;
    }

    public void setAllowUriQueryParameter(boolean allowUriQueryParameter) {
        this.allowUriQueryParameter = allowUriQueryParameter;
    }

    public void setBearerTokenHeaderName(String bearerTokenHeaderName) {
        this.bearerTokenHeaderName = bearerTokenHeaderName;
    }

    private String resolveFromAuthorizationHeader(HttpServletRequest request) {
        String bearer;
        String authorization = request.getHeader(this.bearerTokenHeaderName);
        if (!StringUtils.startsWithIgnoreCase((String)authorization, (String)(bearer = "bearer"))) {
            return null;
        }
        Matcher matcher = AUTHORIZATION_PATTERN.matcher(authorization);
        if (!matcher.matches()) {
            BearerTokenError error = BearerTokenErrors.invalidToken((String)"Bearer token is malformed");
            throw new OAuth2AuthenticationException((OAuth2Error)error);
        }
        return matcher.group("token");
    }

    private String resolveFromRequestParameters(HttpServletRequest request) {
        String[] values = request.getParameterValues(this.requestParameterName);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        BearerTokenError error = BearerTokenErrors.invalidRequest((String)"Found multiple bearer tokens in the request");
        throw new OAuth2AuthenticationException((OAuth2Error)error);
    }

    private boolean isParameterTokenSupportedForRequest(HttpServletRequest request) {
        return this.allowFormEncodedBodyParameter && "POST".equals(request.getMethod()) || this.allowUriQueryParameter && "GET".equals(request.getMethod());
    }
}

