/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.supplier;

import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import top.dcenter.ums.security.jwt.api.supplier.JwtClaimTypeConverterSupplier;
import top.dcenter.ums.security.jwt.enums.JwtCustomClaimNames;

public class UmsJwtClaimTypeConverterSupplier
implements JwtClaimTypeConverterSupplier {
    private static final ConversionService CONVERSION_SERVICE = ClaimConversionService.getSharedInstance();
    private static final TypeDescriptor OBJECT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Object.class);
    private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor INSTANT_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(Instant.class);
    private static final TypeDescriptor URL_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(URL.class);
    private static final TypeDescriptor COLLECTION_STRING_DESCRIPTOR = TypeDescriptor.collection(Collection.class, (TypeDescriptor)STRING_TYPE_DESCRIPTOR);
    private static final TypeDescriptor MAP_STRING_OBJECT_DESCRIPTOR = TypeDescriptor.map(LinkedHashMap.class, (TypeDescriptor)STRING_TYPE_DESCRIPTOR, (TypeDescriptor)OBJECT_TYPE_DESCRIPTOR);

    private static Converter<Object, ?> getConverter(TypeDescriptor targetDescriptor) {
        return source -> CONVERSION_SERVICE.convert(source, OBJECT_TYPE_DESCRIPTOR, targetDescriptor);
    }

    @Override
    @NonNull
    public Map<String, Converter<Object, ?>> getConverter() {
        HashMap map = new HashMap(16);
        map.put(JwtCustomClaimNames.USER_ID.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(STRING_TYPE_DESCRIPTOR));
        map.put(JwtCustomClaimNames.USERNAME.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(STRING_TYPE_DESCRIPTOR));
        map.put(JwtCustomClaimNames.TENANT_ID.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(STRING_TYPE_DESCRIPTOR));
        map.put(JwtCustomClaimNames.CLIENT_ID.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(STRING_TYPE_DESCRIPTOR));
        map.put(JwtCustomClaimNames.USER_DETAILS.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(MAP_STRING_OBJECT_DESCRIPTOR));
        map.put(JwtCustomClaimNames.AUTHORITIES.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(COLLECTION_STRING_DESCRIPTOR));
        map.put(JwtCustomClaimNames.REFRESH_TOKEN_JTI.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(STRING_TYPE_DESCRIPTOR));
        map.put(JwtCustomClaimNames.SCOPE.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(COLLECTION_STRING_DESCRIPTOR));
        map.put(JwtCustomClaimNames.SCP.getClaimName(), UmsJwtClaimTypeConverterSupplier.getConverter(COLLECTION_STRING_DESCRIPTOR));
        return Collections.unmodifiableMap(map);
    }
}

