/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.jwt.validator;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public final class JwtNotBeforeValidator
implements OAuth2TokenValidator<Jwt> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final Duration DEFAULT_MAX_CLOCK_SKEW = Duration.of(60L, ChronoUnit.SECONDS);
    private final Duration clockSkew;
    private Clock clock = Clock.systemUTC();

    public JwtNotBeforeValidator() {
        this(DEFAULT_MAX_CLOCK_SKEW);
    }

    public JwtNotBeforeValidator(Duration clockSkew) {
        Assert.notNull((Object)clockSkew, (String)"clockSkew cannot be null");
        this.clockSkew = clockSkew;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        Assert.notNull((Object)jwt, (String)"jwt cannot be null");
        Instant notBefore = jwt.getNotBefore();
        if (notBefore != null && Instant.now(this.clock).plus(this.clockSkew).isBefore(notBefore)) {
            OAuth2Error oAuth2Error = this.createOAuth2Error(String.format("Jwt used before %s", jwt.getNotBefore()));
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{oAuth2Error});
        }
        return OAuth2TokenValidatorResult.success();
    }

    private OAuth2Error createOAuth2Error(String reason) {
        this.logger.debug((Object)reason);
        return new OAuth2Error("invalid_request", reason, "https://tools.ietf.org/html/rfc6750#section-3.1");
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }
}

