/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.premission.config;

import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchyImpl;
import org.springframework.security.access.vote.RoleHierarchyVoter;
import top.dcenter.ums.security.core.premission.config.RbacPropertiesAutoConfiguration;
import top.dcenter.ums.security.core.premission.properties.PermissionProperties;

@Configuration(proxyBeanMethods=false)
@Order(value=99)
@AutoConfigureAfter(value={RbacPropertiesAutoConfiguration.class})
public class RoleHierarchyAutoConfiguration {
    private final PermissionProperties permissionProperties;

    public RoleHierarchyAutoConfiguration(PermissionProperties permissionProperties) {
        this.permissionProperties = permissionProperties;
    }

    @Bean
    public RoleHierarchy roleHierarchy() {
        RoleHierarchyImpl roleHierarchy = new RoleHierarchyImpl();
        List<String> roleHierarchyList = this.permissionProperties.getRoleHierarchy();
        String roleHierarchyStringRepresentation = String.join((CharSequence)"\n", roleHierarchyList);
        roleHierarchy.setHierarchy(roleHierarchyStringRepresentation);
        return roleHierarchy;
    }

    @Bean
    public RoleHierarchyVoter roleHierarchyVoter(RoleHierarchy roleHierarchy) {
        return new RoleHierarchyVoter(roleHierarchy);
    }
}

