/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.premission.evaluator;

import java.io.Serializable;
import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.core.api.premission.service.UriAuthorizeService;

public class UriAuthoritiesPermissionEvaluator
implements PermissionEvaluator {
    private static final Logger log = LoggerFactory.getLogger(UriAuthoritiesPermissionEvaluator.class);
    private final UriAuthorizeService uriAuthorizeService;

    public UriAuthoritiesPermissionEvaluator(UriAuthorizeService uriAuthorizeService) {
        this.uriAuthorizeService = uriAuthorizeService;
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        if (targetDomainObject == null || permission == null) {
            return false;
        }
        if (targetDomainObject instanceof String) {
            String uri = (String)targetDomainObject;
            return this.hasPermission(authentication, null, uri, permission);
        }
        if (targetDomainObject instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)targetDomainObject;
            boolean hasPermission = this.uriAuthorizeService.hasPermission(authentication, request);
            Object principal = authentication.getPrincipal();
            String sid = request.getSession(true).getId();
            String ip = IpUtil.getRealIp((HttpServletRequest)request);
            String uri = request.getRequestURI();
            long now = Instant.now().toEpochMilli();
            String referer = request.getHeader("referer");
            String userAgent = request.getHeader("User-Agent");
            String method = request.getMethod();
            if (hasPermission) {
                log.info("URI\u6743\u9650\u63a7\u5236-\u653e\u884c: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, uri, method, now, referer, userAgent});
                return true;
            }
            log.warn("URI\u6743\u9650\u63a7\u5236-\u7981\u6b62: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, uri, method, now, referer, userAgent});
            return false;
        }
        log.warn("URI\u6743\u9650\u63a7\u5236-\u4f20\u53c2\u7c7b\u578b\u9519\u8bef: targetDomainObject={}, permission={}", targetDomainObject, permission);
        return false;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        if (permission instanceof String) {
            String uriAuthority = (String)permission;
            boolean hasPermission = this.uriAuthorizeService.hasPermission(authentication, targetType, uriAuthority);
            Object principal = authentication.getPrincipal();
            long now = Instant.now().toEpochMilli();
            if (hasPermission) {
                log.info("URI\u6743\u9650\u63a7\u5236-\u653e\u884c: user={}, uri={},time={}, permission={}", new Object[]{principal, targetType, now, permission});
                return true;
            }
            log.warn("URI\u6743\u9650\u63a7\u5236-\u7981\u6b62: user={}, uri={}, time={}, permission={}", new Object[]{principal, targetType, now, permission});
        }
        return false;
    }
}

