/*
 * Decompiled with CFR 0.152.
 */
package top.focess.command;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.focess.command.DataConverter;
import top.focess.command.data.BooleanBuffer;
import top.focess.command.data.DataBuffer;
import top.focess.command.data.DoubleBuffer;
import top.focess.command.data.IntBuffer;
import top.focess.command.data.LongBuffer;
import top.focess.command.data.StringBuffer;

public class DataCollection {
    private static final Map<DataConverter<?>, BufferGetter> DATA_CONVERTER_BUFFER_MAP = Maps.newConcurrentMap();
    private final Map<Class<?>, DataBuffer> buffers = Maps.newHashMap();

    public DataCollection(@NotNull DataConverter<?>[] dataConverters) {
        HashMap map = Maps.newHashMap();
        for (DataConverter<?> dataConverter : dataConverters) {
            map.compute(dataConverter, (k, v) -> {
                if (v == null) {
                    v = 0;
                }
                Integer n = v;
                Integer n2 = v = Integer.valueOf(v + 1);
                return v;
            });
        }
        for (DataConverter dataConverter : map.keySet()) {
            this.buffers.put(dataConverter.getTargetClass(), DATA_CONVERTER_BUFFER_MAP.get(dataConverter).newBuffer((Integer)map.get(dataConverter)));
        }
    }

    public static void register(DataConverter<?> dataConverter, BufferGetter bufferGetter) {
        DATA_CONVERTER_BUFFER_MAP.put(dataConverter, bufferGetter);
    }

    public static void unregister(DataConverter<?> dataConverter) {
        DATA_CONVERTER_BUFFER_MAP.remove(dataConverter);
    }

    public static void unregisterAll() {
        DATA_CONVERTER_BUFFER_MAP.clear();
    }

    void flip() {
        for (Class<?> c : this.buffers.keySet()) {
            this.buffers.get(c).flip();
        }
    }

    public @NonNull String get() {
        return Objects.requireNonNull(this.get(String.class));
    }

    public int getInt() {
        return Objects.requireNonNull(this.get(Integer.class));
    }

    public double getDouble() {
        return Objects.requireNonNull(this.get(Double.class));
    }

    public boolean getBoolean() {
        return Objects.requireNonNull(this.get(Boolean.class));
    }

    public long getLong() {
        return Objects.requireNonNull(this.get(Long.class));
    }

    @Contract(value="_,!null->!null")
    public <T> T getOrDefault(Class<T> cls, T t) {
        try {
            if (this.buffers.get(cls) == null) {
                throw new UnsupportedOperationException();
            }
            return this.buffers.get(cls).get();
        }
        catch (Exception e) {
            return t;
        }
    }

    @Contract(value="_,_,!null->!null")
    public <T> T getOrDefault(Class<T> cls, int index, T t) {
        try {
            if (this.buffers.get(cls) == null) {
                throw new UnsupportedOperationException();
            }
            return this.buffers.get(cls).get(index);
        }
        catch (Exception e) {
            return t;
        }
    }

    <T> void write(Class<T> cls, T t) {
        this.buffers.compute(cls, (key, value) -> {
            if (value == null) {
                throw new UnsupportedOperationException();
            }
            value.put(t);
            return value;
        });
    }

    @NotNull
    public <T> T get(Class<T> c) {
        if (this.buffers.get(c) == null) {
            throw new UnsupportedOperationException();
        }
        return this.buffers.get(c).get();
    }

    @NotNull
    public <T> T get(Class<T> c, int index) {
        if (this.buffers.get(c) == null) {
            throw new UnsupportedOperationException();
        }
        return this.buffers.get(c).get(index);
    }

    static {
        DataCollection.register(DataConverter.LONG_DATA_CONVERTER, LongBuffer::allocate);
        DataCollection.register(DataConverter.DEFAULT_DATA_CONVERTER, StringBuffer::allocate);
        DataCollection.register(DataConverter.INTEGER_DATA_CONVERTER, IntBuffer::allocate);
        DataCollection.register(DataConverter.DOUBLE_DATA_CONVERTER, DoubleBuffer::allocate);
        DataCollection.register(DataConverter.BOOLEAN_DATA_CONVERTER, BooleanBuffer::allocate);
    }

    @FunctionalInterface
    public static interface BufferGetter {
        public DataBuffer<?> newBuffer(int var1);
    }
}

