/*
 * Decompiled with CFR 0.152.
 */
package top.focess.command.data;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.focess.command.data.DataBuffer;

public class BooleanBuffer
extends DataBuffer<Boolean> {
    private final ByteBuffer byteBuffer;

    private BooleanBuffer(int size) {
        this.byteBuffer = ByteBuffer.allocate(size);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static BooleanBuffer allocate(int size) {
        return new BooleanBuffer(size);
    }

    @Override
    public void put(Boolean b) {
        this.byteBuffer.put((byte)(b != false ? 1 : 0));
    }

    @Override
    @NotNull
    public Boolean get() {
        return this.byteBuffer.get() != 0;
    }

    @Override
    @NotNull
    public Boolean get(int index) {
        return this.byteBuffer.get(index) != 0;
    }

    @Override
    public void flip() {
        this.byteBuffer.flip();
    }
}

