/*
 * Decompiled with CFR 0.152.
 */
package top.focess.command;

import org.jetbrains.annotations.NotNull;

public enum CommandResult {
    ALLOW(1),
    REFUSE(2),
    COMMAND_REFUSED(4),
    ARGS(8),
    ARGS_EXECUTED(16),
    REFUSE_EXCEPTION(32),
    ALL(ALLOW, REFUSE, COMMAND_REFUSED, ARGS, ARGS_EXECUTED),
    NEGATIVE(REFUSE, COMMAND_REFUSED, ARGS, ARGS_EXECUTED, REFUSE_EXCEPTION),
    EXECUTED(ALLOW, REFUSE, ARGS_EXECUTED),
    NONE(0);

    private final int value;

    private CommandResult(CommandResult result, CommandResult ... results) {
        this(CommandResult.toInt(result, results));
    }

    private CommandResult(int value) {
        this.value = value;
    }

    private static int toInt(@NotNull CommandResult result, @NotNull CommandResult[] results) {
        int ret = result.getValue();
        for (CommandResult r : results) {
            ret |= r.getValue();
        }
        return ret;
    }

    public int getValue() {
        return this.value;
    }

    public boolean contains(CommandResult result) {
        return (this.value & result.getValue()) == result.getValue();
    }

    public boolean isExecuted() {
        return EXECUTED.contains(this);
    }
}

