/*
 * Decompiled with CFR 0.152.
 */
package top.focess.command.data;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.focess.command.data.DataBuffer;

public class ObjectBuffer
extends DataBuffer<Object> {
    private final Object[] objects;
    private int pos;
    private int limit;

    private ObjectBuffer(int size) {
        this.objects = new Object[size];
        this.pos = 0;
        this.limit = size;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ObjectBuffer allocate(int size) {
        return new ObjectBuffer(size);
    }

    @Override
    public void flip() {
        this.limit = this.pos;
        this.pos = 0;
    }

    @Override
    public void put(Object o) {
        if (this.pos == this.limit) {
            throw new BufferOverflowException();
        }
        this.objects[this.pos++] = o;
    }

    @Override
    @NotNull
    public Object get() {
        if (this.pos == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.objects[this.pos++];
    }

    @Override
    @NotNull
    public Object get(int index) {
        return this.objects[index];
    }
}

