/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.dev.threadtweak;

import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_148;
import net.minecraft.class_2966;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.MagicLibProperties;
import top.hendrixshen.magiclib.impl.dev.threadtweak.LoggingForkJoinWorkerThread;
import top.hendrixshen.magiclib.mixin.dev.accessor.UtilAccessor;

public class ThreadTweaker {
    @NotNull
    public static ExecutorService replaceForkJoinWorker(String name, int priority, int counter) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new ForkJoinPool(class_3532.method_15340((int)counter, (int)1, (int)Short.MAX_VALUE), forkJoinPool -> {
            String workerName = "Worker-" + name + "-" + atomicInteger.getAndIncrement();
            MagicLib.getLogger().debug("Initialized " + workerName);
            LoggingForkJoinWorkerThread forkJoinWorkerThread = new LoggingForkJoinWorkerThread(forkJoinPool, UtilAccessor.magiclib$getLogger());
            forkJoinWorkerThread.setPriority(priority);
            forkJoinWorkerThread.setName(workerName);
            return forkJoinWorkerThread;
        }, (thread, throwable) -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof class_148) {
                class_2966.method_12847((String)((class_148)throwable).method_631().method_568());
                System.exit(-1);
            }
            UtilAccessor.magiclib$getLogger().error(String.format("Caught exception in thread %s", thread), throwable);
        }, true);
    }

    @NotNull
    public static ExecutorService replaceThreadWorker(String name, int priority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return Executors.newCachedThreadPool(runnable -> {
            String workerName = name + "-" + atomicInteger.getAndIncrement();
            MagicLib.getLogger().debug("Initialized " + workerName);
            Thread thread = new Thread(runnable);
            thread.setName(workerName);
            thread.setDaemon(true);
            thread.setPriority(priority);
            thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            return thread;
        });
    }

    public static int getBootstrapCount() {
        try {
            int i = Integer.parseInt(MagicLibProperties.DEV_QOL_THREAD_TWEAK_COUNT_BOOTSTRAP.getStringValue());
            return Math.max(i, 1);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public static int getMainCount() {
        try {
            int i = Integer.parseInt(MagicLibProperties.DEV_QOL_THREAD_TWEAK_COUNT_MAIN.getStringValue());
            return Math.max(i, 1);
        }
        catch (NumberFormatException e) {
            return Default.mainCount;
        }
    }

    public static int getBootstrapPriority() {
        try {
            int i = Integer.parseInt(MagicLibProperties.DEV_QOL_THREAD_TWEAK_PRIORITY_BOOTSTRAP.getStringValue());
            return class_3532.method_15340((int)i, (int)1, (int)10);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public static int getGamePriority() {
        try {
            int i = Integer.parseInt(MagicLibProperties.DEV_QOL_THREAD_TWEAK_PRIORITY_GAME.getStringValue());
            return class_3532.method_15340((int)i, (int)1, (int)10);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public static int getIntegratedServerPriority() {
        try {
            int i = Integer.parseInt(MagicLibProperties.DEV_QOL_THREAD_TWEAK_PRIORITY_INTEGRATED_SERVER.getStringValue());
            return class_3532.method_15340((int)i, (int)1, (int)10);
        }
        catch (NumberFormatException e) {
            return 5;
        }
    }

    public static int getIOPriority() {
        try {
            int i = Integer.parseInt(MagicLibProperties.DEV_QOL_THREAD_TWEAK_PRIORITY_IO.getStringValue());
            return class_3532.method_15340((int)i, (int)1, (int)10);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public static int getMainPriority() {
        try {
            int i = Integer.parseInt(MagicLibProperties.DEV_QOL_THREAD_TWEAK_PRIORITY_MAIN.getStringValue());
            return class_3532.method_15340((int)i, (int)1, (int)10);
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    public static class Default {
        public static final int bootstrapCount = 1;
        public static final int mainCount = MagicLibProperties.getMaxBackgroundThreads();
        public static final int bootstrapPriority = 1;
        public static final int gamePriority = 5;
        public static final int integratedServerPriority = 5;
        public static final int ioPriority = 1;
        public static final int mainPriority = 1;
    }
}

