/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib;

import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;
import org.semver4j.Semver;
import top.hendrixshen.magiclib.SharedConstants;

public enum MagicLibVersion {
    VERSION_0_1("0.1"),
    VERSION_0_2("0.2"),
    VERSION_0_3("0.3"),
    VERSION_0_4("0.4"),
    VERSION_0_5("0.5"),
    VERSION_0_6("0.6"),
    VERSION_0_7("0.7"),
    VERSION_0_8("0.8");

    private static final AtomicReference<Object> currentMagicLibVersion;
    private final Semver semver;
    private final String originalVersion;

    private MagicLibVersion(String versionName) {
        this.originalVersion = versionName.trim();
        this.semver = Semver.coerce((String)this.originalVersion);
    }

    @Nullable
    public static MagicLibVersion toMagicLibVersion(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof MagicLibVersion) {
            return (MagicLibVersion)((Object)value);
        }
        String name = value.toString();
        Semver semver = Semver.coerce((String)name);
        if (semver == null) {
            return null;
        }
        for (MagicLibVersion version : MagicLibVersion.values()) {
            if (version.getSemver().getMajor() != semver.getMajor() || version.getSemver().getMinor() != semver.getMinor()) continue;
            return version;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MagicLibVersion getCurrentMagicLibVersion() {
        Object $value = currentMagicLibVersion.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = currentMagicLibVersion;
            synchronized (atomicReference) {
                $value = currentMagicLibVersion.get();
                if ($value == null) {
                    MagicLibVersion actualValue = MagicLibVersion.toMagicLibVersion(SharedConstants.getMagiclibVersion());
                    $value = actualValue == null ? currentMagicLibVersion : actualValue;
                    currentMagicLibVersion.set($value);
                }
            }
        }
        return (MagicLibVersion)((Object)($value == currentMagicLibVersion ? null : $value));
    }

    public Semver getSemver() {
        return this.semver;
    }

    public String getOriginalVersion() {
        return this.originalVersion;
    }

    static {
        currentMagicLibVersion = new AtomicReference();
    }
}

