/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.api.platform;

public enum PlatformType {
    FABRIC("fabric"),
    FABRIC_LIKE("fabric_like"),
    FORGE("forge"),
    NEOFORGE("neoforge"),
    FORGE_LIKE("forge_like"),
    QUILT("quilt");

    private final String name;

    private PlatformType(String name) {
        this.name = name;
    }

    public boolean isForgeLike(PlatformType type) {
        return this == FORGE_LIKE || type == FORGE_LIKE || type == this;
    }

    public boolean isFabricLike(PlatformType type) {
        return this == FABRIC_LIKE || type == FABRIC_LIKE || type == this;
    }

    public boolean matches(PlatformType type) {
        return type == this || this.isFabricLike(type) || this.isForgeLike(type);
    }

    public String getName() {
        return this.name;
    }
}

