/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.dependency;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AnnotationNode;
import org.spongepowered.asm.util.Annotations;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependencies;
import top.hendrixshen.magiclib.api.dependency.annotation.Dependency;
import top.hendrixshen.magiclib.impl.dependency.DependencyCheckResult;
import top.hendrixshen.magiclib.impl.dependency.DependencyContainer;
import top.hendrixshen.magiclib.util.collect.ValueContainer;

public class DependenciesContainer<T> {
    private final List<DependencyContainer<T>> requireDependencies;
    private final List<DependencyContainer<T>> conflictDependencies;

    private DependenciesContainer(List<DependencyContainer<T>> requireDependencies, List<DependencyContainer<T>> conflictDependencies) {
        this.requireDependencies = requireDependencies;
        this.conflictDependencies = conflictDependencies;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <T> DependenciesContainer<T> of(@NotNull Dependencies dependencies, T obj) {
        return new DependenciesContainer<T>(DependenciesContainer.generateRequirement(dependencies.require(), obj), DependenciesContainer.generateRequirement(dependencies.conflict(), obj));
    }

    @NotNull
    public static <T> DependenciesContainer<T> of(AnnotationNode annotationNode, T obj) {
        List requireNode = Annotations.getValue((AnnotationNode)annotationNode, (String)"require", (boolean)true);
        List conflictNode = Annotations.getValue((AnnotationNode)annotationNode, (String)"conflict", (boolean)true);
        return new DependenciesContainer<T>(requireNode.stream().map(node -> DependencyContainer.of(node, obj)).collect(Collectors.toList()), conflictNode.stream().map(node -> DependencyContainer.of(node, obj)).collect(Collectors.toList()));
    }

    public List<DependencyCheckResult> checkRequire() {
        ArrayList ret = Lists.newArrayList();
        this.requireDependencies.forEach(dependency -> ret.add(dependency.check()));
        return ret.stream().filter(ValueContainer::isPresent).map(ValueContainer::get).filter(r -> !r.isSuccess()).collect(Collectors.toList());
    }

    public List<DependencyCheckResult> checkConflict() {
        ArrayList ret = Lists.newArrayList();
        this.conflictDependencies.forEach(dependency -> ret.add(dependency.check()));
        return ret.stream().filter(ValueContainer::isPresent).map(ValueContainer::get).filter(DependencyCheckResult::isSuccess).collect(Collectors.toList());
    }

    public boolean isSatisfied() {
        return this.isConflictSatisfied() && this.isRequireSatisfied();
    }

    public boolean isRequireSatisfied() {
        return this.requireDependencies.stream().allMatch(DependencyContainer::isSatisfied);
    }

    public boolean isConflictSatisfied() {
        return this.conflictDependencies.stream().noneMatch(DependencyContainer::isSatisfied);
    }

    private static <T> List<DependencyContainer<T>> generateRequirement(Dependency[] dependencies, T type) {
        return Arrays.stream(dependencies).map(dependency -> DependencyContainer.of(dependency, type)).collect(Collectors.toList());
    }
}

