/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.mixin;

import java.lang.annotation.Annotation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.util.Annotations;

public class AnnotationRestorer {
    private final Class<? extends Annotation> annotationClass;
    @Nullable
    private AnnotationNode previousAnnotationNode;

    public AnnotationRestorer(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void preApply(ClassNode targetClass) {
        this.previousAnnotationNode = Annotations.getVisible((ClassNode)targetClass, this.annotationClass);
    }

    public void postApply(@NotNull ClassNode targetClass) {
        String descriptor = Type.getDescriptor(this.annotationClass);
        List annotationNodes = targetClass.visibleAnnotations;
        if (annotationNodes == null) {
            return;
        }
        int index = -1;
        for (int i = 0; i < annotationNodes.size(); ++i) {
            if (!descriptor.equals(((AnnotationNode)annotationNodes.get((int)i)).desc)) continue;
            index = i;
            break;
        }
        if (this.previousAnnotationNode == null && index != -1) {
            annotationNodes.remove(index);
        } else if (this.previousAnnotationNode != null) {
            annotationNodes.set(index, this.previousAnnotationNode);
        }
    }

    public boolean matchAnnotationClass(Class<? extends Annotation> annotationClass) {
        return this.annotationClass == annotationClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotationRestorer)) {
            return false;
        }
        AnnotationRestorer other = (AnnotationRestorer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<? extends Annotation> this$annotationClass = this.annotationClass;
        Class<? extends Annotation> other$annotationClass = other.annotationClass;
        if (this$annotationClass == null ? other$annotationClass != null : !this$annotationClass.equals(other$annotationClass)) {
            return false;
        }
        AnnotationNode this$previousAnnotationNode = this.previousAnnotationNode;
        AnnotationNode other$previousAnnotationNode = other.previousAnnotationNode;
        return !(this$previousAnnotationNode == null ? other$previousAnnotationNode != null : !this$previousAnnotationNode.equals(other$previousAnnotationNode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnnotationRestorer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends Annotation> $annotationClass = this.annotationClass;
        result = result * 59 + ($annotationClass == null ? 43 : $annotationClass.hashCode());
        AnnotationNode $previousAnnotationNode = this.previousAnnotationNode;
        result = result * 59 + ($previousAnnotationNode == null ? 43 : $previousAnnotationNode.hashCode());
        return result;
    }
}

