/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.impl.mixin.checker;

import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.util.Annotations;
import top.hendrixshen.magiclib.api.dependency.DependencyCheckException;
import top.hendrixshen.magiclib.api.dependency.annotation.CompositeDependencies;
import top.hendrixshen.magiclib.api.i18n.I18n;
import top.hendrixshen.magiclib.api.mixin.checker.MixinDependencyCheckFailureCallback;
import top.hendrixshen.magiclib.api.mixin.checker.MixinDependencyChecker;
import top.hendrixshen.magiclib.impl.dependency.DependenciesContainer;
import top.hendrixshen.magiclib.util.MiscUtil;
import top.hendrixshen.magiclib.util.collect.InfoNode;
import top.hendrixshen.magiclib.util.mixin.MixinUtil;

public class SimpleMixinChecker
implements MixinDependencyChecker {
    private MixinDependencyCheckFailureCallback failureCallback;

    @Override
    public boolean check(String targetClassName, String mixinClassName) {
        ClassNode targetClassNode = MixinUtil.getClassNode(targetClassName);
        ClassNode mixinClassNode = MixinUtil.getClassNode(mixinClassName);
        if (targetClassNode == null || mixinClassNode == null) {
            return false;
        }
        AnnotationNode mixinConfigNode = Annotations.getVisible((ClassNode)mixinClassNode, CompositeDependencies.class);
        List nodes = Annotations.getValue((AnnotationNode)mixinConfigNode, (String)"value", (boolean)true);
        if (nodes.isEmpty()) {
            return true;
        }
        List<DependenciesContainer<?>> dependencies = nodes.stream().map(node -> DependenciesContainer.of(node, targetClassNode)).collect(Collectors.toList());
        if (dependencies.stream().anyMatch(DependenciesContainer::isSatisfied)) {
            return true;
        }
        InfoNode rootNode = new InfoNode(null, I18n.tr("magiclib.dependency.checker.mixin.title", mixinClassName, targetClassName));
        MiscUtil.generateDependencyCheckMessage(dependencies, rootNode);
        this.onCheckFailure(targetClassName, mixinClassName, new DependencyCheckException(rootNode.toString()));
        return false;
    }

    @Override
    public void setCheckFailureCallback(MixinDependencyCheckFailureCallback callback) {
        this.failureCallback = callback;
    }

    private void onCheckFailure(String targetClassName, String mixinClassName, DependencyCheckException result) {
        if (this.failureCallback != null) {
            this.failureCallback.callback(targetClassName, mixinClassName, result);
        }
    }
}

