/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.util.GsonUtil;

public class JsonUtil {
    public static void loadStringMapFromJson(InputStream inputStream, BiConsumer<String, String> biConsumer) {
        JsonObject jsonObject = (JsonObject)GsonUtil.GSON.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), JsonObject.class);
        jsonObject.entrySet().forEach(entry -> biConsumer.accept((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
    }

    public static JsonObject readJson(@NotNull URL url) throws IOException {
        InputStream inputStream = url.openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        JsonObject jsonObject = (JsonObject)GsonUtil.GSON.fromJson((Reader)inputStreamReader, JsonObject.class);
        inputStreamReader.close();
        inputStream.close();
        return jsonObject;
    }
}

