/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util;

import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.semver4j.Semver;
import top.hendrixshen.magiclib.MagicLib;
import top.hendrixshen.magiclib.api.i18n.I18n;

public class VersionUtil {
    @Contract(pure=true)
    public static boolean isVersionSatisfyPredicates(String version, @NotNull Collection<String> versionPredicates) {
        return versionPredicates.isEmpty() || versionPredicates.stream().allMatch(versionPredicate -> VersionUtil.isVersionSatisfyPredicate(version, versionPredicate));
    }

    private static boolean isVersionSatisfyPredicate(String version, String versionPredicate) {
        try {
            Semver semver = new Semver(version);
            return semver.satisfies(versionPredicate);
        }
        catch (Exception e) {
            MagicLib.getLogger().error("Failed to parse version {}: {}", (Object)version, (Object)e);
            return false;
        }
    }

    @NotNull
    public static String getVersionType(@NotNull String version) {
        return VersionUtil.translateVersionType(version, "en_us");
    }

    @NotNull
    public static String translateVersionType(@NotNull String version) {
        return VersionUtil.translateVersionType(version, I18n.getCurrentLanguageCode());
    }

    @NotNull
    public static String translateVersionType(@NotNull String version, String languageCode) {
        if (version.endsWith("beta")) {
            return I18n.trByCode(languageCode, "magiclib.misc.version_type.beta");
        }
        if (version.endsWith("dev")) {
            return I18n.trByCode(languageCode, "magiclib.misc.version_type.development");
        }
        if (version.endsWith("stable")) {
            return I18n.trByCode(languageCode, "magiclib.misc.version_type.stable");
        }
        return I18n.trByCode(languageCode, "magiclib.misc.version_type.unknown");
    }
}

