/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class InfoNode {
    private String name;
    private InfoNode parent;
    private final List<InfoNode> children = Lists.newArrayList();

    public InfoNode(InfoNode parent, String name) {
        Objects.requireNonNull(name, "Null name");
        if (parent != null) {
            parent.addChild(this);
        }
        this.parent = parent;
        this.name = name;
    }

    public void moveTo(InfoNode newParent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = newParent;
        if (newParent != null) {
            newParent.addChild(this);
        }
    }

    private void addChild(InfoNode infoNode) {
        this.children.add(infoNode);
    }

    @NotNull
    private String getString(String prefix) {
        return prefix + this.name + "\n" + this.children.stream().map(n -> n.getString(prefix + "\t")).collect(Collectors.joining());
    }

    @NotNull
    public ImmutableList<InfoNode> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    @NotNull
    public String toString() {
        return this.getString("").replaceAll("\n*$", "");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InfoNode getParent() {
        return this.parent;
    }
}

