/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.collect.tuple;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.util.collect.tuple.Pair;

public class ImmutablePair<L, R>
extends Pair<L, R> {
    private static final ImmutablePair<?, ?>[] EMPTY_ARRAY = new ImmutablePair[0];
    private static final ImmutablePair NULL = new ImmutablePair<Object, Object>(null, null);
    private final L left;
    private final R right;

    @Contract(value="_, _ -> new")
    @NotNull
    public static <L, R> Pair<L, R> of(L left, R right) {
        return new ImmutablePair<L, R>(Objects.requireNonNull(left, "left"), Objects.requireNonNull(right, "right"));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <L, R> Pair<L, R> of(Map.Entry<L, R> pair) {
        return pair == null ? ImmutablePair.nullPair() : new ImmutablePair<L, R>(pair.getKey(), pair.getValue());
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <L, R> Pair<L, R> ofNullable(L left, R right) {
        return new ImmutablePair<L, R>(left, right);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <L, R> Pair<L, R> left(L left) {
        return ImmutablePair.ofNullable(left, null);
    }

    @NotNull
    public static <L, R> Pair<L, R> right(R right) {
        return ImmutablePair.ofNullable(null, right);
    }

    public static <L, R> ImmutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> ImmutablePair<L, R> nullPair() {
        return NULL;
    }

    public ImmutablePair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException();
    }
}

