/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.collect.tuple;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.util.collect.tuple.Triple;

public class ImmutableTriple<L, M, R>
extends Triple<L, M, R> {
    private static final ImmutableTriple<?, ?, ?>[] EMPTY_ARRAY = new ImmutableTriple[0];
    private static final ImmutableTriple NULL = new ImmutableTriple<Object, Object, Object>(null, null, null);
    private final L left;
    private final M middle;
    private final R right;

    @NotNull
    public static <L, M, R> ImmutableTriple<L, M, R> of(L left, M middle, R right) {
        return new ImmutableTriple<L, M, R>(Objects.requireNonNull(left, "left"), Objects.requireNonNull(middle, "middle"), Objects.requireNonNull(right, "right"));
    }

    @NotNull
    public static <L, M, R> ImmutableTriple<L, M, R> ofNullable(L left, M middle, R right) {
        return new ImmutableTriple<L, M, R>(left, middle, right);
    }

    public static <L, M, R> ImmutableTriple<L, M, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, M, R> ImmutableTriple<L, M, R> nullPair() {
        return NULL;
    }

    private ImmutableTriple(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public M getMiddle() {
        return this.middle;
    }

    @Override
    public R getRight() {
        return this.right;
    }
}

