/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.collect.tuple;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.util.collect.tuple.Pair;

public class MutablePair<L, R>
extends Pair<L, R> {
    private static final MutablePair<?, ?>[] EMPTY_ARRAY = new MutablePair[0];
    private static final MutablePair NULL = new MutablePair<Object, Object>(null, null);
    private L left;
    private R right;

    @Contract(value="_, _ -> new")
    @NotNull
    public static <L, R> Pair<L, R> of(L left, R right) {
        return new MutablePair<L, R>(Objects.requireNonNull(left), Objects.requireNonNull(right));
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <L, R> Pair<L, R> of(Map.Entry<L, R> pair) {
        return pair == null ? MutablePair.nullPair() : new MutablePair<L, R>(pair.getKey(), pair.getValue());
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <L, R> Pair<L, R> ofNullable(L left, R right) {
        return new MutablePair<L, R>(left, right);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <L, R> Pair<L, R> left(L left) {
        return MutablePair.ofNullable(left, null);
    }

    @NotNull
    public static <L, R> Pair<L, R> right(R right) {
        return MutablePair.ofNullable(null, right);
    }

    public static <L, R> MutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> MutablePair<L, R> nullPair() {
        return NULL;
    }

    public MutablePair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public void setLeft(L left) {
        this.left = left;
    }

    @Override
    public void setRight(R right) {
        this.right = right;
    }

    @Override
    public R setValue(R value) {
        R result = this.getRight();
        this.setRight(value);
        return result;
    }
}

