/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.collect.tuple;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import top.hendrixshen.magiclib.util.collect.tuple.Triple;

public class MutableTriple<L, M, R>
extends Triple<L, M, R> {
    private static final MutableTriple<?, ?, ?>[] EMPTY_ARRAY = new MutableTriple[0];
    private static final MutableTriple NULL = new MutableTriple<Object, Object, Object>(null, null, null);
    private L left;
    private M middle;
    private R right;

    @NotNull
    public static <L, M, R> MutableTriple<L, M, R> of(L left, M middle, R right) {
        return new MutableTriple<L, M, R>(Objects.requireNonNull(left, "left"), Objects.requireNonNull(middle, "middle"), Objects.requireNonNull(right, "right"));
    }

    @NotNull
    public static <L, M, R> MutableTriple<L, M, R> ofNullable(L left, M middle, R right) {
        return new MutableTriple<L, M, R>(left, middle, right);
    }

    public static <L, M, R> MutableTriple<L, M, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, M, R> MutableTriple<L, M, R> nullPair() {
        return NULL;
    }

    private MutableTriple(L left, M middle, R right) {
        this.left = left;
        this.middle = middle;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public M getMiddle() {
        return this.middle;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public void setLeft(L left) {
        this.left = left;
    }

    @Override
    public void setMiddle(M middle) {
        this.middle = middle;
    }

    @Override
    public void setRight(R right) {
        this.right = right;
    }
}

