/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.mixin;

import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import top.hendrixshen.magiclib.util.ReflectionUtil;
import top.hendrixshen.magiclib.util.collect.ValueContainer;
import top.hendrixshen.magiclib.util.collect.tuple.ImmutablePair;
import top.hendrixshen.magiclib.util.collect.tuple.Pair;

public class MixinInternals {
    public static Extensions getExtensions() {
        IMixinTransformer transformer = (IMixinTransformer)MixinEnvironment.getDefaultEnvironment().getActiveTransformer();
        return (Extensions)transformer.getExtensions();
    }

    public static SortedSet<IMixinInfo> getMixins(ITargetClassContext context) {
        ValueContainer mixins = ReflectionUtil.getDeclaredFieldValue(context.getClass(), "mixins", (Object)context);
        return (SortedSet)mixins.orElseThrow();
    }

    public static Object getState(IMixinInfo context) {
        ValueContainer state = ReflectionUtil.getDeclaredFieldValue(context.getClass(), "state", (Object)context);
        return state.orElseThrow();
    }

    public static ClassNode getStateClassNode(IMixinInfo context) {
        Object state = MixinInternals.getState(context);
        ValueContainer classNode = ReflectionUtil.getDeclaredFieldValue(state.getClass(), "classNode", state);
        return (ClassNode)classNode.orElseThrow();
    }

    public static String getName(IMixinInfo info) {
        ValueContainer name = ReflectionUtil.getDeclaredFieldValue(info.getClass(), "name", (Object)info);
        return (String)name.orElseThrow();
    }

    public static void registerExtension(IExtension extension) {
        MixinInternals.registerExtension(extension, false);
    }

    public static void registerExtension(IExtension extension, boolean highPriority) {
        Pair<List<IExtension>, Map<Class<? extends IExtension>, IExtension>> container = MixinInternals.getExtensionContainer();
        if (highPriority) {
            container.getLeft().add(0, extension);
        } else {
            container.getLeft().add(extension);
        }
        container.getRight().put(extension.getClass(), extension);
    }

    public static void unregisterExtension(IExtension extension) {
        Pair<List<IExtension>, Map<Class<? extends IExtension>, IExtension>> container = MixinInternals.getExtensionContainer();
        container.getLeft().remove(extension);
        container.getRight().remove(extension.getClass());
    }

    @NotNull
    private static Pair<List<IExtension>, Map<Class<? extends IExtension>, IExtension>> getExtensionContainer() {
        Extensions extensions = MixinInternals.getExtensions();
        ValueContainer extensionListContainer = ReflectionUtil.getDeclaredFieldValue("org.spongepowered.asm.mixin.transformer.ext.Extensions", "extensions", (Object)extensions);
        ValueContainer extensionMapContainer = ReflectionUtil.getDeclaredFieldValue("org.spongepowered.asm.mixin.transformer.ext.Extensions", "extensionMap", (Object)extensions);
        return ImmutablePair.of((List)extensionListContainer.orElseThrow(), (Map)extensionMapContainer.orElseThrow());
    }
}

