/*
 * Decompiled with CFR 0.152.
 */
package top.hendrixshen.magiclib.util.mixin;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.service.MixinService;
import top.hendrixshen.magiclib.MagicLib;

public class MixinUtil {
    @Nullable
    public static ClassNode getClassNode(String className) {
        try {
            return MixinService.getService().getBytecodeProvider().getClassNode(className);
        }
        catch (IOException | ClassNotFoundException e) {
            MagicLib.getLogger().error("Failed to fetch class node {}: ", (Object)className, (Object)e);
            return null;
        }
    }

    @NotNull
    public static List<String> getMethodVisibleAnnotations(@NotNull MethodNode methodNode) {
        ArrayList ret = Lists.newArrayList();
        if (methodNode.visibleAnnotations != null) {
            ret.addAll(methodNode.visibleAnnotations.stream().map(annotationNode -> annotationNode.desc).collect(Collectors.toList()));
        }
        return ret;
    }

    @NotNull
    public static List<String> getMethodInvisibleAnnotations(@NotNull MethodNode methodNode) {
        ArrayList ret = Lists.newArrayList();
        if (methodNode.invisibleAnnotations != null) {
            ret.addAll(methodNode.invisibleAnnotations.stream().map(annotationNode -> annotationNode.desc).collect(Collectors.toList()));
        }
        return ret;
    }

    @NotNull
    public static List<String> getMethodAnnotations(@NotNull MethodNode methodNode) {
        List<String> ret = MixinUtil.getMethodInvisibleAnnotations(methodNode);
        ret.addAll(MixinUtil.getMethodVisibleAnnotations(methodNode));
        return ret;
    }

    public static boolean containsMethodNode(@NotNull Collection<MethodNode> methodNodes, String name, String desc) {
        return methodNodes.stream().anyMatch(methodNode -> methodNode.name.equals(name) && methodNode.desc.equals(desc));
    }
}

