/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc.ref;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.ioc.annotation.Controller;
import top.hserver.core.ioc.annotation.Filter;
import top.hserver.core.ioc.annotation.Hook;
import top.hserver.core.ioc.annotation.WebSocket;
import top.hserver.core.ioc.ref.PackageScanner;
import top.hserver.core.ioc.util.ClassLoadUtil;

public class ClasspathPackageScanner
implements PackageScanner {
    private static final Logger log = LoggerFactory.getLogger(ClasspathPackageScanner.class);
    private String basePackage;

    public ClasspathPackageScanner(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public List<Class<?>> getBeansPackage() throws IOException {
        ArrayList clazzLis = new ArrayList();
        List<Class<?>> classes = ClassLoadUtil.LoadClasses(this.basePackage, true);
        for (Class<?> aClass : classes) {
            if (aClass.getAnnotation(Bean.class) == null) continue;
            clazzLis.add(aClass);
        }
        return clazzLis;
    }

    @Override
    public List<Class<?>> getWebSocketPackage() throws IOException {
        ArrayList clazzLis = new ArrayList();
        List<Class<?>> classes = ClassLoadUtil.LoadClasses(this.basePackage, true);
        for (Class<?> aClass : classes) {
            if (aClass.getAnnotation(WebSocket.class) == null) continue;
            clazzLis.add(aClass);
        }
        return clazzLis;
    }

    @Override
    public List<Class<?>> getControllersPackage() throws IOException {
        ArrayList clazzLis = new ArrayList();
        List<Class<?>> classes = ClassLoadUtil.LoadClasses(this.basePackage, true);
        for (Class<?> aClass : classes) {
            if (aClass.getAnnotation(Controller.class) == null) continue;
            clazzLis.add(aClass);
        }
        return clazzLis;
    }

    @Override
    public List<Class<?>> getHooksPackage() throws IOException {
        ArrayList clazzLis = new ArrayList();
        List<Class<?>> classes = ClassLoadUtil.LoadClasses(this.basePackage, true);
        for (Class<?> aClass : classes) {
            if (aClass.getAnnotation(Hook.class) == null) continue;
            clazzLis.add(aClass);
        }
        return clazzLis;
    }

    @Override
    public List<Class<?>> getFiltersPackage() throws IOException {
        ArrayList clazzLis = new ArrayList();
        List<Class<?>> classes = ClassLoadUtil.LoadClasses(this.basePackage, true);
        for (Class<?> aClass : classes) {
            if (aClass.getAnnotation(Filter.class) == null) continue;
            clazzLis.add(aClass);
        }
        return clazzLis;
    }
}

