/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.server.context.StaticFile;
import top.hserver.core.server.exception.BusinessException;
import top.hserver.core.server.util.ExceptionUtil;

public class StaticHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticHandler.class);
    private String basePath = "/static";

    public StaticFile handler(String uri) {
        InputStream input;
        if ("/".equals(uri)) {
            uri = "/index.html";
        }
        if ((input = this.getResourceStreamFromJar(this.basePath + uri)) != null) {
            return this.buildStaticFile(input, uri);
        }
        return null;
    }

    private InputStream getResourceStreamFromJar(String uri) {
        return StaticHandler.class.getResourceAsStream(uri);
    }

    private StaticFile buildStaticFile(InputStream input, String url) {
        StaticFile staticFile = new StaticFile();
        try {
            int len;
            int available = input.available();
            staticFile.setSize(available);
            int i = url.lastIndexOf("/");
            int i1 = url.lastIndexOf(".");
            if (i <= -1 || i1 <= 0) {
                return null;
            }
            String fileName = url.substring(i + 1, url.length());
            String[] split = fileName.split("\\.");
            staticFile.setFileName(fileName);
            staticFile.setFileType(split[1]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int size = 0;
            ByteBuf byteBuf = Unpooled.buffer();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                size += len;
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
            byteBuf.writeBytes((InputStream)inputStream, size);
            staticFile.setByteBuf(byteBuf);
            baos.close();
            ((InputStream)inputStream).close();
            input.close();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38:" + e.getMessage());
            try {
                input.close();
            }
            catch (Exception e1) {
                log.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38:" + e.getMessage());
                throw new BusinessException(503, "\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38" + ExceptionUtil.getMessage(e));
            }
            throw new BusinessException(503, "\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38" + ExceptionUtil.getMessage(e));
        }
        return staticFile;
    }
}

