/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.ReferenceCountUtil;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.WebSocketHandler;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.server.handlers.Ws;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerHandler.class);
    public static final Map<String, String> WebSocketRouter = new ConcurrentHashMap<String, String>();
    private WebSocketServerHandshaker handshaker;
    private WebSocketHandler webSocketHandler;
    private String uri;
    private String uid;

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.initHandler();
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ReferenceCountUtil.retain((Object)msg);
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) {
        if (this.isWebSocketRequest(req)) {
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(req.uri(), null, true);
            this.handshaker = wsFactory.newHandshaker(req);
            if (this.handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshaker.handshake(ctx.channel(), req);
                this.uri = req.uri();
                this.uid = UUID.randomUUID().toString();
                this.initHandler();
                CompletableFuture.completedFuture(new Ws(ctx, this.uid)).thenAcceptAsync(this.webSocketHandler::onConnect, (Executor)ctx.executor());
            }
        } else {
            ReferenceCountUtil.retain((Object)req);
            ctx.fireChannelRead((Object)req);
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            CompletableFuture.completedFuture(new Ws(ctx, this.uid)).thenAcceptAsync(this.webSocketHandler::disConnect, (Executor)ctx.executor());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (!(frame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException("unsupported frame type: " + frame.getClass().getName());
        }
        CompletableFuture.completedFuture(new Ws(ctx, ((TextWebSocketFrame)frame).text(), this.uid)).thenAcceptAsync(this.webSocketHandler::onMessage, (Executor)ctx.executor());
    }

    private boolean isWebSocketRequest(HttpRequest req) {
        return req != null && WebSocketRouter.get(req.uri()) != null && req.decoderResult().isSuccess() && "websocket".equals(req.headers().get("Upgrade"));
    }

    private void initHandler() {
        this.webSocketHandler = (WebSocketHandler)IocUtil.getBean(WebSocketRouter.get(this.uri));
    }
}

