/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.stat;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import java.net.InetSocketAddress;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import top.hserver.core.server.stat.IpData;
import top.hserver.core.server.stat.RequestData;

public class StatisticsController {
    private static Map<String, IpData> ipMap = new ConcurrentHashMap<String, IpData>();
    private static Map<String, Integer> urlMap = new ConcurrentHashMap<String, Integer>();
    private static Deque<RequestData> logRequestQue = new ConcurrentLinkedDeque<RequestData>();
    private static AtomicInteger uniqueIpCount = new AtomicInteger();
    private static AtomicInteger count = new AtomicInteger();

    public void addToConnectionDeque(ChannelHandlerContext ctx, String url) {
        ChannelTrafficShapingHandler ch = (ChannelTrafficShapingHandler)ctx.channel().pipeline().get("shaping-handler");
        ch.trafficCounter().stop();
        if (logRequestQue.size() < 16) {
            logRequestQue.addLast(new RequestData(this.getClientIp(ctx), url, ch.trafficCounter().cumulativeWrittenBytes(), ch.trafficCounter().cumulativeReadBytes(), ch.trafficCounter().lastWriteThroughput()));
        } else {
            logRequestQue.removeFirst();
            logRequestQue.addLast(new RequestData(this.getClientIp(ctx), url, ch.trafficCounter().cumulativeWrittenBytes(), ch.trafficCounter().cumulativeReadBytes(), ch.trafficCounter().lastWriteThroughput()));
        }
        ch.trafficCounter().resetCumulativeTime();
    }

    public void IncreaseCount() {
        count.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToIpMap(ChannelHandlerContext ctx) {
        String clientIP = ((InetSocketAddress)ctx.channel().remoteAddress()).getHostString();
        Map<String, IpData> map = ipMap;
        synchronized (map) {
            if (!ipMap.containsKey(clientIP)) {
                ipMap.put(clientIP, new IpData());
                uniqueIpCount.incrementAndGet();
            } else {
                ipMap.get(clientIP).incrementCount();
                ipMap.get(clientIP).updateTime();
            }
        }
    }

    public static void processRedirectRequest(String redirectedUrl) {
        if (!urlMap.containsKey(redirectedUrl)) {
            urlMap.put(redirectedUrl, 1);
        } else {
            urlMap.put(redirectedUrl, urlMap.get(redirectedUrl) + 1);
        }
    }

    private String getClientIp(ChannelHandlerContext ctx) {
        return ((InetSocketAddress)ctx.channel().remoteAddress()).getHostString();
    }

    public Map<String, IpData> getIpMap() {
        return ipMap;
    }

    public static Deque<RequestData> getLogRequestQue() {
        return logRequestQue;
    }

    public Map<String, Integer> getUrlMap() {
        return urlMap;
    }

    public AtomicInteger getCount() {
        return count;
    }

    public AtomicInteger getUniqueIpCount() {
        return uniqueIpCount;
    }
}

