/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.task;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import top.hserver.core.bean.TaskBean;
import top.hserver.core.interfaces.TaskJob;
import top.hserver.core.ioc.IocUtil;

public class TaskManager {
    public static Boolean IS_OK = false;
    private static final Map<String, TaskBean> nameTask = new ConcurrentHashMap<String, TaskBean>();

    public static void addTask(String name, Integer time, Class<? extends TaskJob> taskJob, final Object ... args) {
        try {
            final TaskJob taskJob1 = taskJob.newInstance();
            Timer sysTimer = new Timer(name);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (IS_OK.booleanValue()) {
                        try {
                            taskJob1.exec(args);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            nameTask.put(name, new TaskBean(sysTimer, timerTask));
            sysTimer.schedule(timerTask, time.intValue(), (long)time.intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean removeTask(String name) {
        TaskBean taskBean = nameTask.get(name);
        if (taskBean != null) {
            Timer timer = taskBean.getTimer();
            TimerTask timerTask = taskBean.getTimerTask();
            timerTask.cancel();
            timer.cancel();
            timer.purge();
            nameTask.remove(name);
            return true;
        }
        return false;
    }

    public static void initTask(String name, Integer time, final String className, final Method method, final Object ... args) {
        try {
            Timer sysTimer = new Timer(name);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (IS_OK.booleanValue()) {
                        try {
                            Object bean = IocUtil.getBean(className);
                            method.invoke(bean, args);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            nameTask.put(name, new TaskBean(sysTimer, timerTask));
            sysTimer.schedule(timerTask, time.intValue(), (long)time.intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

