/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.bean.ClientData;
import top.hserver.cloud.client.RegClient;
import top.hserver.cloud.proxy.CloudProxy;
import top.hserver.cloud.server.RegServer;
import top.hserver.cloud.task.BroadcastTask;
import top.hserver.cloud.util.NetUtil;
import top.hserver.core.task.TaskManager;

public class CloudManager {
    private static final Logger log = LoggerFactory.getLogger(CloudManager.class);
    public static final int port = 9527;
    private static Map<String, ClientData> serviceDataMap = new ConcurrentHashMap<String, ClientData>();

    public static void run() {
        CloudProxy.clearCache();
        try {
            Properties pps = new Properties();
            InputStream resourceAsStream = CloudManager.class.getResourceAsStream("/application.properties");
            pps.load(resourceAsStream);
            Object open = pps.get("app.cloud.open");
            if (open != null && Boolean.valueOf(open.toString()).booleanValue()) {
                Object slave_open;
                Object master_open = pps.get("app.cloud.master.open");
                if (master_open != null && Boolean.valueOf(master_open.toString()).booleanValue()) {
                    new RegServer().start();
                }
                if ((slave_open = pps.get("app.cloud.slave.open")) != null && Boolean.valueOf(slave_open.toString()).booleanValue()) {
                    Object cloud_name = pps.get("app.cloud.name");
                    cloud_name = cloud_name == null ? NetUtil.getIpAddress() : cloud_name + "-->" + NetUtil.getIpAddress();
                    new RegClient().start();
                    TaskManager.addTask(cloud_name.toString(), 5000, BroadcastTask.class, cloud_name.toString());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static void add(String name, ClientData classs) {
        if (serviceDataMap.containsKey(name)) {
            log.warn("\u5df2\u7ecf\u5b58\u5728\uff1a" + name + "Rpc\u670d\u52a1");
            return;
        }
        serviceDataMap.put(name, classs);
    }

    public static boolean isRpcService() {
        return serviceDataMap.size() > 0;
    }

    public static List<String> getClasses() {
        ArrayList<String> list = new ArrayList<String>();
        serviceDataMap.forEach((a, b) -> list.add(b.getAClass()));
        return list;
    }

    public static ClientData get(String name) {
        return serviceDataMap.get(name);
    }
}

