/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.client.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.CloudManager;
import top.hserver.cloud.bean.ClientData;
import top.hserver.cloud.bean.InvokeServiceData;
import top.hserver.cloud.bean.ResultData;
import top.hserver.cloud.common.MSG_TYPE;
import top.hserver.cloud.common.Msg;
import top.hserver.core.ioc.IocUtil;

public class ClientHandler
extends SimpleChannelInboundHandler<Msg> {
    private static final Logger log = LoggerFactory.getLogger(ClientHandler.class);

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Msg msg) throws Exception {
        block1 : switch (msg.getMsg_type()) {
            case INVOKER: {
                Msg msg1 = msg;
                InvokeServiceData data = (InvokeServiceData)msg1.getData();
                log.info("\u8c03\u7528\u4fe1\u606f--->" + data.toString());
                String aClass = data.getAClass();
                ClientData clientData = CloudManager.get(aClass);
                Object bean = IocUtil.getBean(aClass);
                for (Method method : clientData.getMethods()) {
                    if (!method.getName().equals(data.getMethod())) continue;
                    try {
                        Object invoke = method.invoke(bean, data.getObjects());
                        ResultData<String> resultData = new ResultData<String>();
                        resultData.setData(invoke.toString());
                        resultData.setUUID(data.getUUID());
                        resultData.setCode(200);
                        Msg<ResultData<String>> msg2 = new Msg<ResultData<String>>();
                        msg2.setMsg_type(MSG_TYPE.RESULT);
                        msg2.setData(resultData);
                        channelHandlerContext.writeAndFlush(msg2);
                    }
                    catch (Exception e) {
                        ResultData<String> resultData = new ResultData<String>();
                        resultData.setData(e.getMessage());
                        resultData.setUUID(data.getUUID());
                        resultData.setCode(503);
                        Msg<ResultData<String>> msg2 = new Msg<ResultData<String>>();
                        msg2.setMsg_type(MSG_TYPE.RESULT);
                        msg2.setData(resultData);
                        channelHandlerContext.writeAndFlush(msg2);
                    }
                    break block1;
                }
                break;
            }
            default: {
                log.info(msg.toString());
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
    }
}

