/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.future;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import top.hserver.cloud.bean.InvokeServiceData;
import top.hserver.cloud.bean.ResultData;
import top.hserver.cloud.common.MSG_TYPE;
import top.hserver.cloud.common.Msg;
import top.hserver.cloud.future.SyncWriteFuture;
import top.hserver.cloud.future.SyncWriteMap;
import top.hserver.cloud.future.WriteFuture;

public class SyncWrite {
    public ResultData writeAndSync(ChannelHandlerContext channel, InvokeServiceData invokeServiceData, long timeout) throws Exception {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (invokeServiceData == null) {
            throw new NullPointerException("invokeServiceData");
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout <= 0");
        }
        String requestId = UUID.randomUUID().toString();
        invokeServiceData.setUUID(requestId);
        SyncWriteFuture future = new SyncWriteFuture(invokeServiceData.getUUID());
        SyncWriteMap.syncKey.put(invokeServiceData.getUUID(), future);
        ResultData response = this.doWriteAndSync(channel, invokeServiceData, timeout, future);
        SyncWriteMap.syncKey.remove(invokeServiceData.getUUID());
        return response;
    }

    private ResultData doWriteAndSync(ChannelHandlerContext channel, InvokeServiceData invokeServiceData, long timeout, final WriteFuture<ResultData> writeFuture) throws Exception {
        Msg<InvokeServiceData> msg = new Msg<InvokeServiceData>();
        msg.setMsg_type(MSG_TYPE.INVOKER);
        msg.setData(invokeServiceData);
        channel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                writeFuture.setWriteResult(future.isSuccess());
                writeFuture.setCause(future.cause());
                if (!writeFuture.isWriteSuccess()) {
                    SyncWriteMap.syncKey.remove(writeFuture.requestId());
                }
            }
        });
        ResultData resultData = (ResultData)writeFuture.get(timeout, TimeUnit.MILLISECONDS);
        if (resultData == null) {
            if (writeFuture.isTimeout()) {
                throw new TimeoutException();
            }
            throw new Exception(writeFuture.cause());
        }
        return resultData;
    }
}

