/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.Executor;
import top.hserver.cloud.server.handler.FileServerInitializer;

public class ChatServer {
    private final int port;

    public ChatServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        int acceptThreadCount = 1;
        int ioThreadCount = 0;
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bossGroup = new NioEventLoopGroup(acceptThreadCount, (Executor)new NioEventLoopGroup());
            workerGroup = new NioEventLoopGroup(ioThreadCount, (Executor)new NioEventLoopGroup());
            bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
            bootstrap.childHandler((ChannelHandler)new FileServerInitializer());
            Channel ch = bootstrap.bind(this.port).sync().channel();
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

